const express = require("express");
const router = express.Router();
const bcrypt = require("bcryptjs");
const jwt = require("jsonwebtoken");
const db = require("../lib/db.js");
const userMiddleware = require("../middleware/users.js");
const { OAuth2Client } = require("google-auth-library");
const { Expo } = require("expo-server-sdk");
const axios = require('axios')
const moment = require('moment');

const FormData = require('form-data');
const multer = require("multer");

const storage = multer.diskStorage({
  destination: function (req, file, cb) {
    cb(null, "uploads/");
  },
  filename: function (req, file, cb) {
    cb(null, Date.now()+"."+ file.originalname.split('.').pop());
  },
});
const upload = multer({ storage: storage }).single("file");

let pattern = /^05\d{8}$/;
function makeotp(length) {
  var result = "";
  var characters = "0123456789";
  var charactersLength = characters.length;
  for (var i = 0; i < length; i++) {
    result += characters.charAt(Math.floor(Math.random() * charactersLength));
  }
  return result;
}



router.get("/hash", async (req, res, next) => {

  bcrypt.hash(req.query.password, 10, (err, hash) => {
    if (err) {
      return res.status(500).send({
        msg: err,
      });
    } else {
      res.send(hash);
    }
  });
});
  function makeotp(length) {
    var result = "";
    var characters = "0123456789";
    var charactersLength = characters.length;
    for (var i = 0; i < length; i++) {
      result += characters.charAt(Math.floor(Math.random() * charactersLength));
    }
    return result;
  }
  const fs = require('fs');
const exp = require("constants");

router.post("/uploadImage", function (req, res) {
    const {base64}=req.body
   const base64DataURI =base64

// Extract the MIME type and base64 data
const [, mimeType, base64Data] = base64DataURI.match(/^data:(image\/\w+);base64,(.+)$/);

// Determine the file extension based on the MIME type
const extension = mimeType.split('/')[1];

// Convert base64 to binary data
const binaryData = Buffer.from(base64Data, 'base64');
const fileotp=makeotp(20)
// Specify the file path where you want to save the file
const filePath = `uploads/${fileotp}.${extension}`; // The file path includes the determined file extension

// Write the binary data to a file
fs.writeFile(filePath, binaryData, (err) => {
  if (err) {
    console.error('Error writing file:', err);
    res.send({
        data:{
             status:"error",
        msg:err  
        }
     
    })
  } else {
    console.error('File successfully written:', filePath);
       const fileUrl =
        req.protocol + "://" + req.get("host") + "/api/" + filePath;
        res.send({
          data:{
              status:"success",
            msg:'File successfully written:', fileUrl:fileUrl
          }
           ,location:fileUrl
        })
  }
})
});
const XLSX = require('xlsx');
const path = require('path');
var x=0;
var y=0;
function processXLSXFile(filePath) {
  // Load Excel file
  const workbook = XLSX.readFile(filePath);
  
  // Assuming there's only one sheet, if not, iterate through workbook.SheetNames
  const sheetName = workbook.SheetNames[0];
  const worksheet = workbook.Sheets[sheetName];
  
  // Convert Excel to JSON
  const jsonData = XLSX.utils.sheet_to_json(worksheet);
  var itemnoindex
  var quantityindex
  var unitindex
  var priceindex
  jsonData.forEach((item,index) => {
 y++
 console.log("y=",y)
  console.log(Object.keys(item))
      if ( itemnoindex) {
     
        if(itemnoindex&&quantityindex&&quantityindex&&priceindex)
        {
x++
console.log([item[itemnoindex], item[quantityindex], item[unitindex], item[priceindex], item[priceindex] * 2, item[priceindex] * 1.7, item[priceindex] * 1.5],x)
          db.query(
            `insert into products (itemno, quantity, unit, cost, price1, price2, price3) values(?,?,?,?,?,?,?)`,
            [item[itemnoindex], item[quantityindex], item[unitindex], item[priceindex], item[priceindex] * 2, item[priceindex] * 1.7, item[priceindex] * 1.5],
                          (err, result) => {
                if (err) {
                    console.log([item[itemnoindex], item[quantityindex], item[unitindex], item[priceindex], item[priceindex] * 2, item[priceindex] * 1.7, item[priceindex] * 1.5])
                } else {
                    // Do something with the result if needed
                }
            }
        );
        }
       
      }
      else{

        Object.keys(item).forEach(key => {
          if(item[key] == "ITEM NO"){

            itemnoindex=key
          }
          if(item[key] == "T/QTY"){

            quantityindex=key
          }
          if(item[key] == "UNIT"){

            unitindex=key
          }

          if(item[key] == "U/PRICE"){

            priceindex=key
          }

        });


    
      }
  });
  
  console.log(`Conversion completed for ${filePath}`);
}
/*router.get("/uploadxlsx", function (req, res) {
  const directoryPath = 'xlsx';

  // Read all files in the directory
  fs.readdir(directoryPath, (err, files) => {
      if (err) {
          console.log('Error reading directory:', err);
          return;
      }
      
      // Iterate through each file
      files.forEach(file => {
          // Check if the file has .xlsx extension
          if (path.extname(file) === '.xlsx') {
              const filePath = path.join(directoryPath, file);
              // Process the XLSX file
              processXLSXFile(filePath);
          }
      });
  });

  res.send("done")
});*/
router.post("/signup", (req, res, next) => {
  const {name, mobile,city,address, password } = req.body;
  bcrypt.hash(password, 10, (err, hash) => {
    if (err) {
      return res.status(500).send({
        msg: err,
      });
    } else {
      db.query(
        `insert into customers (name,mobile,city,address,source,password) values(?,?,?,?,?,?)`,
        [name, mobile,city,address,"السوق الالكتروني", hash],
        (err, result) => {
          if (err) {
            console.log(err);
            if (err.code == "ER_DUP_ENTRY") {
             res.send({
              status:"error",
              msg:"المستخدم هذا موجود بالفعل"
             })
            }
          } else { 
            const token = jwt.sign(
              {
                userId: result.insertId,
                role:"customer"
              },
              process.env.JWT_KEY,
              {
                expiresIn: "60d",
              }
            );

            db.query(
              `UPDATE customers SET lastlogin = now() WHERE id = '${result.insertId}'`
            );
       

            return res.status(200).send({
              status: "success",
              msg: "Logged In!",
              token,
            });
           

          }
        }
      );
    }
  });
});
router.get("/getUserInfo",userMiddleware.isLoggedIn, function (req, res) {
  db.query(
    `select * from customers where id =?`,[req.userData.userId],
    (err, result) => {
      if (err) {
        console.log(err)
      } else {
        res.send({
          status: "success",
          data: result,
        });
      }
    }
  );

});
router.post("/editUserInfo",userMiddleware.isLoggedIn, function (req, res) {
  const {name,mobile,city,address}=req.body
  db.query(
    `update customers set name=?,mobile=?,city=?,address=? where id=?`,[name,mobile,city,address,req.userData.userId],
    (err, result) => {
      if (err) {
        if (err.code == "ER_DUP_ENTRY") {
          res.send({
          status: "error",
          msg: "رقم الهاتف مستخدم بالفعل",
        });
      }
      } else {
        res.send({
          status: "success",
          msg: "تم تعديل بيانات المستخدم بنجاح",
        });
      }
    }
  );

});
router.post("/forgotPassword", function (req, res) {
  const {mobile}=req.body
  const otp=makeotp(6)
  db.query(
    `update customers set otp=? where mobile=?`,[otp,mobile],
    (err, result) => {
      if (err) {
          res.send({
          status: "error",
          msg: "حدث خطأ , الرجاء المحاولة لاحقا",
        });
      
      } else {


      const apiUrl = 'http://sms.htd.ps/API/SendSMS.aspx';
const apiUser = process.env.smspaluser;
const apiPassword = process.env.smspalpassword;
const sender = process.env.smspalsender;
const message = 'رمز التفعيل الخاص بك هو ' + otp;
const to = mobile;

const queryString = `id=${apiUser}&sender=${sender}&to=${to}&msg=${encodeURIComponent(message)}`;

axios
  .get(`${apiUrl}?${queryString}`)
  .then(res => {
    console.error(`statusCode: ${res.statusCode}`);
    console.error(res);
  })
  .catch(error => {
    console.error(error);
  });
                              res.send({
                                status: "success",
                  
                                msg: "تم ارسال الرمز الى الرقم المدخل",
                              });
      }
    }
  );

});
router.get("/checkOTP", function (req, res) {
  const {mobile,otp}=req.query
  db.query(
    `select * from customers where (mobile=? and otp=?)`,[mobile,otp],
    (err, result) => {
      if (err) {
        console.log(err)
      } else {
       
        if(result.length>0){
          const token = jwt.sign(
            {
              userId: result[0].id,
              role:"customer"
            },
            process.env.JWT_KEY,
            {
              expiresIn: "60d",
            }
          );
          return res.status(200).send({
            status: "success",
            msg: "Logged In!",
            token,
          });


        }
        else{
          db.query(`update customers set otp=? where mobile=?`,[makeotp(6),mobile])

          res.send({
            status: "error",
            msg:"الرمز الذي قمت بادخاله غير صحيح"
          })
        }
      }
    }
  );

});
router.post("/newPasswordCustomer",userMiddleware.isLoggedIn, function (req, res) {
  
  const {password}=req.body

    
  bcrypt.hash(password, 10, (err, hash) => {
    if (err) {
      return res.status(500).send({
        msg: err,
      });
    } else {
     
        db.query(
            `update customers set password=? where id =?`,[hash,req.userData.userId],
            (err, result) => {
              if (err) {
                console.log(err)
              } else {
                res.send({
                  status: "success",
                  msg: "تم تغيير كلمة المرور بنجاح",
                });
              }
            }
          );
        


    }
  });
   

});
router.get("/getProducts",userMiddleware.isSuperAdmin, function (req, res) {
  db.query(
    `select products.*,categories.id as categoryId,categories.name as categoryName from products left join categories on products.category=categories.id order by products.id desc`,
    (err, result) => {
      if (err) {
        console.log(err)
      } else {
        res.send({
          status: "success",
          data: result,
        });
      }
    }
  );

});

router.get("/getProduct", function (req, res) {
  const { id } = req.query;

  const getProductQuery = `
    SELECT 
      products.id, 
      products.itemno,
      products.image,
      products.name,
      products.quantity,
      products.unit,
      products.price1 as price,
      products.barcode,
      products.description,
      products.views,
      products.deletedprice,
      categories.id as categoryId,
      categories.name as categoryName 
    FROM 
      products 
    LEFT JOIN 
      categories 
    ON 
      products.category = categories.id 
    WHERE 
      (products.id = ?)
  `;

  const getProductImagesQuery = `
    SELECT * 
    FROM productImages 
    WHERE productId = ?
  `;

  const getProductPropertiesQuery = `
    SELECT 
      pl.name as label, 
      pv.name as value, 
      pv.label as vlabel
    FROM 
      productsoptions pp
    JOIN 
      productsoptionsvalues pv ON pp.optionvalue = pv.id
    JOIN 
      productsoptionslabels pl ON pv.label = pl.id
    WHERE 
      pp.product = ?
  `;

  db.query(getProductQuery, [id], (err, productResult) => {
    if (err) {
      console.log(err);
      return res.status(500).send({
        status: "error",
        msg: "Error fetching product details",
        err,
      });
    }

    if (productResult.length === 0) {
      return res.status(404).send({
        status: "error",
        msg: "Product not found",
      });
    }

    const product = productResult[0];

    db.query(getProductImagesQuery, [id], (err, imagesResult) => {
      if (err) {
        console.log(err);
        return res.status(500).send({
          status: "error",
          msg: "Error fetching product images",
          err,
        });
      }

      db.query(getProductPropertiesQuery, [id], (err, propertiesResult) => {
        if (err) {
          console.log(err);
          return res.status(500).send({
            status: "error",
            msg: "Error fetching product properties",
            err,
          });
        }

        const properties = {};

        propertiesResult.forEach((row) => {
          if (!properties[row.label]) {
            properties[row.label] = [];
          }
          properties[row.label].push(row.value);
        });

        const productProperties = Object.keys(properties).map((label) => ({
          label,
          values: properties[label],
        }));

        res.status(200).send({
          status: "success",
          data: {
            product,
            images: imagesResult,
            properties: productProperties,
          },
        });

        db.query(` update products set views=views+1 where id=?`,[id]);
      
      });
    });
  });
});
router.get("/getMostViewedProducts", function (req, res) {
  db.query(
    ` SELECT 
      products.id, 
      products.itemno,
      products.image,
      products.name,
      products.quantity,
      products.unit,
      products.price1 as price,
      products.barcode,
      products.description,
      products.views,
      products.deletedprice,
      categories.id as categoryId,
      categories.name as categoryName 
    FROM 
      products 
    LEFT JOIN 
      categories 
    ON 
      products.category = categories.id 
      
      order by products.views desc limit 4`,
    (err, result) => {
      if (err) {
        console.log(err)
      } else {
        res.send({
          status: "success",
          data: result,
        });
      }
    }
  );

});
router.get("/getRandomProducts", function (req, res) {
  db.query(
    ` SELECT 
      products.id, 
      products.itemno,
      products.image,
      products.name,
      products.quantity,
      products.unit,
      products.price1 as price,
      products.barcode,
      products.description,
      products.views,
      products.deletedprice,
      categories.id as categoryId,
      categories.name as categoryName 
    FROM 
      products 
    LEFT JOIN 
      categories 
    ON 
      products.category = categories.id ORDER BY RAND() limit ?`,[parseInt(req.query.count, 10)],
    (err, result) => {
      if (err) {
        console.log(err)
        res.send({
          status:"error",
          msg:err
        })
      } else {
        res.send({
          status: "success",
          data: result,
        });
      }
    }
  );

});
router.get("/getProductsListings", async function (req, res) {
  try {
    // First, get the list of all categories
    const categoriesQuery = `SELECT id as categoryId, name as categoryName FROM categories`;
    const categoriesResult = await new Promise((resolve, reject) => {
      db.query(categoriesQuery, (err, result) => {
        if (err) {
          return reject(err);
        }
        resolve(result);
      });
    });

    // Initialize the response array
    const response = [];

    // Loop through each category and get 10 random products
    for (const category of categoriesResult) {
      const productsQuery = `
        SELECT 
          products.id, 
          products.itemno,
          products.image,
          products.name,
          products.quantity,
          products.unit,
          products.price1 as price,
          products.barcode,
          products.description,
          products.views,
          products.deletedprice
        FROM 
          products 
        WHERE 
          products.category = ? 
        ORDER BY products.id desc
        LIMIT 12`;

      const productsResult = await new Promise((resolve, reject) => {
        db.query(productsQuery, [category.categoryId], (err, result) => {
          if (err) {
            return reject(err);
          }
          resolve(result);
        });
      });

      response.push({
        categoryName: category.categoryName,
        categoryId: category.categoryId,
        products: productsResult,
      });
    }

    res.send({
      status: "success",
      data: response,
    });
  } catch (err) {
    console.log(err);
    res.send({
      status: "error",
      msg: err.message,
    });
  }
});

router.get("/getProductsByCategory", function (req, res) {
  const {categoryId}=req.query
  db.query(
    `select products.id, products.itemno,products.image,products.name,products.quantity,products.unit,products.price1 as price,products.barcode,products.description,products.views,products.deletedprice,categories.id as categoryId,categories.name as categoryName from products left join categories on products.category=categories.id where products.category=? order by products.id desc`,
    [categoryId],(err, result) => {
      if (err) {
        console.log(err)
      } else {
        res.send({
          status: "success",
          data: result,
        });
      }
    }
  );

});
router.get("/searchProducts", function (req, res) {
  const { que } = req.query;
  if (!que) {
    return res.status(400).send({ status: "error", message: "Query parameter 'que' is required" });
  }

  const words = que.split(' ').map(word => `%${word}%`);
  const whereClauses = words.map(word => 'products.name LIKE ?').join(' OR ');

  const query = `
    SELECT 
      products.id, 
      products.itemno,
      products.image,
      products.name,
      products.quantity,
      products.unit,
      products.price1 as price,
      products.barcode,
      products.description,
      products.views,
      products.deletedprice,
      categories.id as categoryId,
      categories.name as categoryName 
    FROM 
      products 
    LEFT JOIN 
      categories 
    ON 
      products.category = categories.id 
    WHERE 
      ${whereClauses} 
    ORDER BY 
      products.id DESC
  `;

  db.query(query, words, (err, result) => {
    if (err) {
      console.log(err);
      res.status(500).send({
        status: "error",
        message: "Database query failed",
      });
    } else {
      res.send({
        status: "success",
        data: result,
      });
    }
  });
});

router.get('/getProductProperties', (req, res) => {
  const {productId} = req.query;

  const query = `
      SELECT pl.name as label, pv.name as value,pv.label as vlabel
      FROM productsoptions pp
      JOIN productsoptionsvalues pv ON pp.optionvalue = pv.id
      JOIN productsoptionslabels pl ON pv.label = pl.id
      WHERE pp.product = ?;
  `;

  db.query(query, [productId], (err, results) => {
      if (err) {
          console.error('Error fetching product properties:', err);
          return res.status(500).json({ error: 'Database error',err });
      }

      const properties = {};

      results.forEach(row => {
          if (!properties[row.label]) {
              properties[row.label] = [];
          }
          properties[row.label].push(row.value);
      });

      const productProperties = Object.keys(properties).map(label => ({
          label,
          values: properties[label]
      }));

      res.status(200).json({
        status:"success",
        data:{
          productId,
          productProperties
        }
     
      });
  });
});
router.get("/getOrderPayments",userMiddleware.isSuperAdmin, function (req, res) {
  db.query(
    `select * from orderspayments where orderId=? order by id asc`,[req.query.orderid],
    (err, result) => {
      if (err) {
        console.log(err)
      } else {
        res.send({
          status: "success",
          data: result,
        });
      }
    }
  );

});
router.post('/addProductProperties',userMiddleware.isSuperAdmin, (req, res) => {
  const {productProperties,productId} = req.body;

  if (!Array.isArray(productProperties)) {
      return res.status(400).json({status:"error", msg: 'Invalid input format' });
  }
  db.query('delete from productsoptions where product=?', [productId], (err,result) => {
    productProperties.forEach(option => {
      const label = option.label;
      const values = option.values;

      // Insert the label into productsoptionslabels table
      db.query('INSERT INTO productsoptionslabels (name) VALUES (?)', [label], (err, result) => {
          if (err) {
              console.error('Error inserting label:', err);
              return res.status(500).json({ status:"error", msg: 'Database error' });
          }

          const labelId = result.insertId;

          // Insert the values into productsoptionsvalues table
          values.forEach(value => {
              db.query('INSERT INTO productsoptionsvalues (label, name) VALUES (?, ?)', [labelId, value], (err,result) => {
                  if (err) {
                    return res.status(500).json({ status:"error", msg: 'Database error' });
                  }
                  const valueId = result.insertId;
                  db.query('INSERT INTO productsoptions (product, optionvalue) VALUES (?, ?)', [productId, valueId], (err,result) => {
                    if (err) {
                      return res.status(500).json({ status:"error", msg: 'Database error' });
                    }
  
                });
              });
          });
      });
  });

});


  res.status(200).json({status:"success", msg: 'Product options added successfully' });
});
router.post("/addOrderPayment",userMiddleware.isSuperAdmin, function (req, res) {
  const {amount,notes,orderId}=req.body
  db.query(
    `insert into orderspayments (amount,notes,orderId) values(?,?,?)`,[amount,notes,orderId],
    (err, result) => {
      if (err) {
        console.error(err)
      } else {
        res.send({
          status:"success",
          msg:"Payment Added"
        })
      }
    }
  );
});
router.post("/addSupplier",userMiddleware.isSuperAdmin, function (req, res) {
  const {name,mobile,company,country,email}=req.body
  db.query(
    `insert into suppliers (name,mobile,company,country,email) values(?,?,?,?,?)`,[name,mobile,company,country,email],
    (err, result) => {
      if (err) {
        console.error(err)
      } else {
        res.send({
          status:"success",
          msg:"Supplier Added"
        })
      }
    }
  );
});
router.post("/addSupplierOrder",userMiddleware.isSuperAdmin, function (req, res) {
  const {supplier,amount}=req.body
  db.query(
    `insert into suppliersorders (supplier,amount) values(?,?)`,[supplier,amount],
    (err, result) => {
      if (err) {
        console.error(err)
      } else {
        res.send({
          status:"success",
          msg:"Order Added"
        })
      }
    }
  );
});
router.post("/addSupplierOrderPayment",userMiddleware.isSuperAdmin, function (req, res) {
  const {orderId,amount,notes}=req.body
  db.query(
    `insert into suppliersorderspayments (orderid,amount,notes) values(?,?,?)`,[orderId,amount,notes],
    (err, result) => {
      if (err) {
        console.error(err)
      } else {
        res.send({
          status:"success",
          msg:"Payment Added"
        })
      }
    }
  );
});
router.post("/addSupplierOrderAttachment",userMiddleware.isSuperAdmin, function (req, res) {
  const {orderId,url,filename}=req.body
  db.query(
    `insert into suppliersordersattachments (orderid,url,filename) values(?,?,?)`,[orderId,url,filename],
    (err, result) => {
      if (err) {
        res.send({
          status:"err",
          msg:err
        })      } else {
        res.send({
          status:"success",
          msg:"Attachment Added"
        })
      }
    }
  );
});
router.post("/addProductImage",userMiddleware.isSuperAdmin, function (req, res) {
  const {productId,url}=req.body
  db.query(
    `insert into productImages (productId,url) values(?,?)`,[productId,url],
    (err, result) => {
      if (err) {
        res.send({
          status:"err",
          msg:err
        })      } else {
        res.send({
          status:"success",
          msg:"Image Added"
        })
      }
    }
  );
});
router.get("/getProductImages",userMiddleware.isSuperAdmin, function (req, res) {
  const {productId}=req.query
  db.query(
    `select * from productImages where productId=?`,[productId],
    (err, result) => {
      if (err) {
        res.send({
          status:"err",
          msg:err
        })      } else {
        res.send({
          status:"success",
          data:result
        })
      }
    }
  );
});
router.get("/deleteProductImage",userMiddleware.isSuperAdmin, function (req, res) {
  const {id}=req.query
  db.query(
    `delete from productImages where id=?`,[id],
    (err, result) => {
      if (err) {
        res.send({
          status:"err",
          msg:err
        })      } else {
        res.send({
          status:"success",
          msg:"Image Deleted"
        })
      }
    }
  );
});
router.post("/addExpense",userMiddleware.isSuperAdmin, function (req, res) {
  const {amount,reason}=req.body
  db.query(
    `insert into expenses (amount,reason) values(?,?)`,[amount,reason],
    (err, result) => {
      if (err) {
        res.send({
          status:"err",
          msg:err
        })      } else {
        res.send({
          status:"success",
          msg:"Expense Added"
        })
      }
    }
  );
});
router.post("/editExpense",userMiddleware.isSuperAdmin, function (req, res) {
  const {amount,reason,id}=req.body
  db.query(
    `update expenses set amount=?,reason=? where id=?`,[amount,reason,id],
    (err, result) => {
      if (err) {
        res.send({
          status:"err",
          msg:err
        })      } else {
        res.send({
          status:"success",
          msg:"Expense Edited"
        })
      }
    }
  );
});
router.get("/deleteExpense",userMiddleware.isSuperAdmin, function (req, res) {
  const {id}=req.query
  db.query(
    `delete from expenses where id=?`,[id],
    (err, result) => {
      if (err) {
        res.send({
          status:"err",
          msg:err
        })      } else {
        res.send({
          status:"success",
          msg:"Expense Deleted"
        })
      }
    }
  );
});





// Function to calculate total sales revenue
function calculateTotalSalesRevenue() {
    return new Promise((resolve, reject) => {
        const query = `
            SELECT 
                SUM((cart.subtotalAmount + orders.shipping - orders.discount) - 
                CASE 
                    WHEN orders.couponType = 'ثابت' THEN orders.couponValue 
                    WHEN orders.couponType = 'نسبة مئوية' THEN cart.subtotalAmount * (orders.couponValue / 100) 
                    ELSE 0 
                END) AS totalSalesRevenue
            FROM orders
            LEFT JOIN (
                SELECT 
                    orderNumber,
                    SUM(price * quantity) AS subtotalAmount
                FROM cart
                GROUP BY orderNumber
            ) AS cart ON orders.orderNumber = cart.orderNumber;
        `;
        db.query(query, (err, result) => {
            if (err) reject(err);
            else resolve(result[0].totalSalesRevenue || 0);
        });
    });
}

// Function to calculate total payments received
function calculateTotalPaymentsReceived() {
    return new Promise((resolve, reject) => {
        const query = `SELECT SUM(amount) AS totalPaymentsReceived FROM orderspayments;`;
        db.query(query, (err, result) => {
            if (err) reject(err);
            else resolve(result[0].totalPaymentsReceived || 0);
        });
    });
}

// Function to calculate total expenses
function calculateTotalExpenses() {
    return new Promise((resolve, reject) => {
        const query = `SELECT SUM(amount) AS totalExpenses FROM expenses;`;
        db.query(query, (err, result) => {
            if (err) reject(err);
            else resolve(result[0].totalExpenses || 0);
        });
    });
}

// Function to calculate total outstanding amounts
function calculateTotalOutstandingAmounts() {
    return new Promise((resolve, reject) => {
        const query = `
            SELECT 
                SUM((orders.shipping + cart.subtotalAmount - orders.discount - IFNULL(payments.totalPaidAmount, 0)) - 
                CASE 
                    WHEN orders.couponType = 'ثابت' THEN orders.couponValue 
                    WHEN orders.couponType = 'نسبة مئوية' THEN cart.subtotalAmount * (orders.couponValue / 100) 
                    ELSE 0 
                END) AS totalOutstandingAmounts
            FROM orders
            LEFT JOIN (
                SELECT 
                    orderNumber,
                    SUM(price * quantity) AS subtotalAmount
                FROM cart
                GROUP BY orderNumber
            ) AS cart ON orders.orderNumber = cart.orderNumber
            LEFT JOIN (
                SELECT 
                    orderId,
                    SUM(amount) AS totalPaidAmount
                FROM orderspayments
                GROUP BY orderId
            ) AS payments ON orders.orderNumber = payments.orderId;
        `;
        db.query(query, (err, result) => {
            if (err) reject(err);
            else resolve(result[0].totalOutstandingAmounts || 0);
        });
    });
}

// Function to calculate total supplier payments
function calculateTotalSupplierPayments() {
    return new Promise((resolve, reject) => {
        const query = `SELECT SUM(amount) AS totalSupplierPayments FROM suppliersorderspayments;`;
        db.query(query, (err, result) => {
            if (err) reject(err);
            else resolve(result[0].totalSupplierPayments || 0);
        });
    });
}

// Function to calculate total supplier orders
function calculateTotalSupplierOrders() {
    return new Promise((resolve, reject) => {
        const query = `SELECT SUM(amount) AS totalSupplierOrders FROM suppliersorders;`;
        db.query(query, (err, result) => {
            if (err) reject(err);
            else resolve(result[0].totalSupplierOrders || 0);
        });
    });
}
function calculateTotalSales() {
  return new Promise((resolve, reject) => {
      const query = `
          SELECT 
              SUM((cart.subtotalAmount + orders.shipping - orders.discount) - 
              CASE 
                  WHEN orders.couponType = 'ثابت' THEN orders.couponValue 
                  WHEN orders.couponType = 'نسبة مئوية' THEN cart.subtotalAmount * (orders.couponValue / 100) 
                  ELSE 0 
              END) AS totalSales
          FROM orders
          LEFT JOIN (
              SELECT 
                  orderNumber,
                  SUM(price * quantity) AS subtotalAmount
              FROM cart
              GROUP BY orderNumber
          ) AS cart ON orders.orderNumber = cart.orderNumber;
      `;
      db.query(query, (err, result) => {
          if (err) reject(err);
          else resolve(result[0].totalSales || 0);
      });
  });
}

// Total Quantity of Items Sold
function calculateTotalQuantityOfItemsSold() {
  return new Promise((resolve, reject) => {
      const query = `
          SELECT SUM(quantity) AS totalQuantitySold FROM cart WHERE orderNumber IS NOT NULL;
      `;
      db.query(query, (err, result) => {
          if (err) reject(err);
          else resolve(result[0].totalQuantitySold || 0);
      });
  });
}

// Breakdown of Sales by Category
function calculateSalesByCategory() {
  return new Promise((resolve, reject) => {
      const query = `
          SELECT 
              categories.name AS category,
              SUM(cart.price * cart.quantity) AS totalSales
          FROM cart
          JOIN products ON cart.productItemNumber = products.itemno
          JOIN categories ON products.category = categories.id
          WHERE cart.orderNumber IS NOT NULL
          GROUP BY categories.name;
      `;
      db.query(query, (err, result) => {
          if (err) reject(err);
          else resolve(result);
      });
  });
}

// Breakdown of Sales by City
function calculateSalesByCity() {
  return new Promise((resolve, reject) => {
      const query = `
          SELECT 
              orders.city,
              SUM((cart.subtotalAmount + orders.shipping - orders.discount) - 
              CASE 
                  WHEN orders.couponType = 'ثابت' THEN orders.couponValue 
                  WHEN orders.couponType = 'نسبة مئوية' THEN cart.subtotalAmount * (orders.couponValue / 100) 
                  ELSE 0 
              END) AS totalSales
          FROM orders
          LEFT JOIN (
              SELECT 
                  orderNumber,
                  SUM(price * quantity) AS subtotalAmount
              FROM cart
              GROUP BY orderNumber
          ) AS cart ON orders.orderNumber = cart.orderNumber
          GROUP BY orders.city;
      `;
      db.query(query, (err, result) => {
          if (err) reject(err);
          else resolve(result);
      });
  });
}

// Average Order Value
function calculateAverageOrderValue() {
  return new Promise((resolve, reject) => {
      const query = `
          SELECT 
              AVG((cart.subtotalAmount + orders.shipping - orders.discount) - 
              CASE 
                  WHEN orders.couponType = 'ثابت' THEN orders.couponValue 
                  WHEN orders.couponType = 'نسبة مئوية' THEN cart.subtotalAmount * (orders.couponValue / 100) 
                  ELSE 0 
              END) AS averageOrderValue
          FROM orders
          LEFT JOIN (
              SELECT 
                  orderNumber,
                  SUM(price * quantity) AS subtotalAmount
              FROM cart
              GROUP BY orderNumber
          ) AS cart ON orders.orderNumber = cart.orderNumber;
      `;
      db.query(query, (err, result) => {
          if (err) reject(err);
          else resolve(result[0].averageOrderValue || 0);
      });
  });
}

// Top Selling Products
function calculateTopSellingProducts() {
  return new Promise((resolve, reject) => {
      const query = `
          SELECT 
              cart.name,
              SUM(cart.quantity) AS totalQuantitySold
          FROM cart
          WHERE cart.orderNumber IS NOT NULL
          GROUP BY cart.name
          ORDER BY totalQuantitySold DESC
          LIMIT 10;
      `;
      db.query(query, (err, result) => {
          if (err) reject(err);
          else resolve(result);
      });
  });
}

// Sales by Month
function calculateSalesByMonth() {
  return new Promise((resolve, reject) => {
      const query = `
          SELECT 
              DATE_FORMAT(orders.date_added, '%Y-%m') AS month,
              SUM((cart.subtotalAmount + orders.shipping - orders.discount) - 
              CASE 
                  WHEN orders.couponType = 'ثابت' THEN orders.couponValue 
                  WHEN orders.couponType = 'نسبة مئوية' THEN cart.subtotalAmount * (orders.couponValue / 100) 
                  ELSE 0 
              END) AS totalSales
          FROM orders
          LEFT JOIN (
              SELECT 
                  orderNumber,
                  SUM(price * quantity) AS subtotalAmount
              FROM cart
              GROUP BY orderNumber
          ) AS cart ON orders.orderNumber = cart.orderNumber
          GROUP BY month;
      `;
      db.query(query, (err, result) => {
          if (err) reject(err);
          else resolve(result);
      });
  });
}

// Sales by Day of the Week
function calculateSalesByDayOfWeek() {
  return new Promise((resolve, reject) => {
      const query = `
          SELECT 
              DAYNAME(orders.date_added) AS dayOfWeek,
              SUM((cart.subtotalAmount + orders.shipping - orders.discount) - 
              CASE 
                  WHEN orders.couponType = 'ثابت' THEN orders.couponValue 
                  WHEN orders.couponType = 'نسبة مئوية' THEN cart.subtotalAmount * (orders.couponValue / 100) 
                  ELSE 0 
              END) AS totalSales
          FROM orders
          LEFT JOIN (
              SELECT 
                  orderNumber,
                  SUM(price * quantity) AS subtotalAmount
              FROM cart
              GROUP BY orderNumber
          ) AS cart ON orders.orderNumber = cart.orderNumber
          GROUP BY dayOfWeek;
      `;
      db.query(query, (err, result) => {
          if (err) reject(err);
          else resolve(result);
      });
  });
}
// Sales Growth Over Time
function calculateSalesGrowthOverTime() {
  return new Promise((resolve, reject) => {
      const query = `
          SELECT 
              DATE_FORMAT(orders.date_added, '%Y-%m') AS month,
              SUM((cart.subtotalAmount + orders.shipping - orders.discount) - 
              CASE 
                  WHEN orders.couponType = 'ثابت' THEN orders.couponValue 
                  WHEN orders.couponType = 'نسبة مئوية' THEN cart.subtotalAmount * (orders.couponValue / 100) 
                  ELSE 0 
              END) AS totalSales
          FROM orders
          LEFT JOIN (
              SELECT 
                  orderNumber,
                  SUM(price * quantity) AS subtotalAmount
              FROM cart
              GROUP BY orderNumber
          ) AS cart ON orders.orderNumber = cart.orderNumber
          GROUP BY month
          ORDER BY month;
      `;
      db.query(query, (err, result) => {
          if (err) reject(err);
          else resolve(result);
      });
  });
}

// Customer Purchase Frequency
function calculateCustomerPurchaseFrequency() {
  return new Promise((resolve, reject) => {
      const query = `
          SELECT 
              AVG(orderCount) AS averagePurchaseFrequency
          FROM (
              SELECT 
                  userId, 
                  COUNT(*) AS orderCount 
              FROM orders 
              GROUP BY userId
          ) AS customerOrders;
      `;
      db.query(query, (err, result) => {
          if (err) reject(err);
          else resolve(result[0].averagePurchaseFrequency || 0);
      });
  });
}

// Top Customers by Revenue
function calculateTopCustomersByRevenue() {
  return new Promise((resolve, reject) => {
      const query = `
          SELECT 
              orders.userId,
              customers.name,
              SUM((cart.subtotalAmount + orders.shipping - orders.discount) - 
              CASE 
                  WHEN orders.couponType = 'ثابت' THEN orders.couponValue 
                  WHEN orders.couponType = 'نسبة مئوية' THEN cart.subtotalAmount * (orders.couponValue / 100) 
                  ELSE 0 
              END) AS totalRevenue
          FROM orders
          JOIN customers ON orders.userId = customers.id
          LEFT JOIN (
              SELECT 
                  orderNumber,
                  SUM(price * quantity) AS subtotalAmount
              FROM cart
              GROUP BY orderNumber
          ) AS cart ON orders.orderNumber = cart.orderNumber
          GROUP BY orders.userId, customers.name
          ORDER BY totalRevenue DESC
          LIMIT 10;
      `;
      db.query(query, (err, result) => {
          if (err) reject(err);
          else resolve(result);
      });
  });
}

// Sales by Product Category Over Time
function calculateSalesByCategoryOverTime() {
  return new Promise((resolve, reject) => {
      const query = `
          SELECT 
              DATE_FORMAT(orders.date_added, '%Y-%m') AS month,
              categories.name AS category,
              SUM(cart.price * cart.quantity) AS totalSales
          FROM orders
          LEFT JOIN cart ON orders.orderNumber = cart.orderNumber
          LEFT JOIN products ON cart.productItemNumber = products.itemno
          LEFT JOIN categories ON products.category = categories.id
          GROUP BY month, categories.name
          ORDER BY month, categories.name;
      `;
      db.query(query, (err, result) => {
          if (err) reject(err);
          else resolve(result);
      });
  });
}

// Discount Impact on Sales
function calculateDiscountImpactOnSales() {
  return new Promise((resolve, reject) => {
      const query = `
          SELECT 
              SUM(discount) AS totalDiscountAmount,
              SUM((cart.subtotalAmount + orders.shipping) - 
              CASE 
                  WHEN orders.couponType = 'ثابت' THEN orders.couponValue 
                  WHEN orders.couponType = 'نسبة مئوية' THEN cart.subtotalAmount * (orders.couponValue / 100) 
                  ELSE 0 
              END) AS totalSalesAfterDiscount
          FROM orders
          LEFT JOIN (
              SELECT 
                  orderNumber,
                  SUM(price * quantity) AS subtotalAmount
              FROM cart
              GROUP BY orderNumber
          ) AS cart ON orders.orderNumber = cart.orderNumber;
      `;
      db.query(query, (err, result) => {
          if (err) reject(err);
          else resolve(result[0]);
      });
  });
}

// Sales by Hour of the Day
function calculateSalesByHourOfDay() {
  return new Promise((resolve, reject) => {
      const query = `
          SELECT 
              HOUR(orders.date_added) AS hourOfDay,
              SUM((cart.subtotalAmount + orders.shipping - orders.discount) - 
              CASE 
                  WHEN orders.couponType = 'ثابت' THEN orders.couponValue 
                  WHEN orders.couponType = 'نسبة مئوية' THEN cart.subtotalAmount * (orders.couponValue / 100) 
                  ELSE 0 
              END) AS totalSales
          FROM orders
          LEFT JOIN (
              SELECT 
                  orderNumber,
                  SUM(price * quantity) AS subtotalAmount
              FROM cart
              GROUP BY orderNumber
          ) AS cart ON orders.orderNumber = cart.orderNumber
          GROUP BY hourOfDay
          ORDER BY hourOfDay;
      `;
      db.query(query, (err, result) => {
          if (err) reject(err);
          else resolve(result);
      });
  });
}

// Inventory Turnover Ratio
function calculateInventoryTurnoverRatio() {
  return new Promise((resolve, reject) => {
      const query = `
          SELECT 
              SUM(cart.quantity * products.cost) / AVG(products.quantity) AS inventoryTurnoverRatio
          FROM cart
          JOIN products ON cart.productItemNumber = products.itemno
          WHERE cart.orderNumber IS NOT NULL;
      `;
      db.query(query, (err, result) => {
          if (err) reject(err);
          else resolve(result[0].inventoryTurnoverRatio || 0);
      });
  });
}

// Profit Margin Analysis
function calculateProfitMarginAnalysis() {
  return new Promise((resolve, reject) => {
      const query = `
          SELECT 
              SUM((cart.price - products.cost) * cart.quantity) / SUM(cart.price * cart.quantity) AS profitMargin
          FROM cart
          JOIN products ON cart.productItemNumber = products.itemno
          WHERE cart.orderNumber IS NOT NULL;
      `;
      db.query(query, (err, result) => {
          if (err) reject(err);
          else resolve(result[0].profitMargin || 0);
      });
  });
}

// Repeat Purchase Rate
function calculateRepeatPurchaseRate() {
  return new Promise((resolve, reject) => {
      const query = `
          SELECT 
              (COUNT(DISTINCT userId) / totalCustomers) AS repeatPurchaseRate
          FROM orders
          JOIN (
              SELECT COUNT(DISTINCT id) AS totalCustomers FROM customers
          ) AS customerCount
          WHERE userId IN (
              SELECT userId
              FROM orders
              GROUP BY userId
              HAVING COUNT(*) > 1
          );
      `;
      db.query(query, (err, result) => {
          if (err) reject(err);
          else resolve(result[0].repeatPurchaseRate || 0);
      });
  });
}

// Sales By Coupon
function calculateSalesByCoupon() {
  return new Promise((resolve, reject) => {
      const query = `
          SELECT 
              orders.coupon,
              SUM((cart.subtotalAmount + orders.shipping - orders.discount) - 
              CASE 
                  WHEN orders.couponType = 'ثابت' THEN orders.couponValue 
                  WHEN orders.couponType = 'نسبة مئوية' THEN cart.subtotalAmount * (orders.couponValue / 100) 
                  ELSE 0 
              END) AS totalSales
          FROM orders
          LEFT JOIN (
              SELECT 
                  orderNumber,
                  SUM(price * quantity) AS subtotalAmount
              FROM cart
              GROUP BY orderNumber
          ) AS cart ON orders.orderNumber = cart.orderNumber
          WHERE orders.coupon IS NOT NULL
          GROUP BY orders.coupon;
      `;
      db.query(query, (err, result) => {
          if (err) reject(err);
          else resolve(result);
      });
  });
}
function calculateTotalProducts() {
  return new Promise((resolve, reject) => {
      const query = `
          SELECT COUNT(*) AS totalProducts
          FROM products;
      `;
      db.query(query, (err, result) => {
          if (err) reject(err);
          else resolve(result[0].totalProducts);
      });
  });
}

// Function to calculate total customers
function calculateTotalCustomers() {
  return new Promise((resolve, reject) => {
      const query = `
          SELECT COUNT(*) AS totalCustomers
          FROM customers;
      `;
      db.query(query, (err, result) => {
          if (err) reject(err);
          else resolve(result[0].totalCustomers);
      });
  });
}
function calculateTotalDebtsOnCustomers() {
  return new Promise((resolve, reject) => {
      const query = `
          SELECT 
              SUM((orders.shipping + cart.subtotalAmount - orders.discount - IFNULL(payments.totalPaidAmount, 0)) - 
              CASE 
                  WHEN orders.couponType = 'ثابت' THEN orders.couponValue 
                  WHEN orders.couponType = 'نسبة مئوية' THEN cart.subtotalAmount * (orders.couponValue / 100) 
                  ELSE 0 
              END) AS totalDebtsOnCustomers
          FROM orders
          LEFT JOIN (
              SELECT 
                  orderNumber,
                  SUM(price * quantity) AS subtotalAmount
              FROM cart
              GROUP BY orderNumber
          ) AS cart ON orders.orderNumber = cart.orderNumber
          LEFT JOIN (
              SELECT 
                  orderId,
                  SUM(amount) AS totalPaidAmount
              FROM orderspayments
              GROUP BY orderId
          ) AS payments ON orders.orderNumber = payments.orderId;
      `;
      db.query(query, (err, result) => {
          if (err) reject(err);
          else resolve(result[0].totalDebtsOnCustomers || 0);
      });
  });
}

// Function to calculate total remaining for suppliers
function calculateTotalRemainingForSuppliers() {
  return new Promise((resolve, reject) => {
      const query = `
          SELECT 
              SUM((suppliersorders.amount - IFNULL(supplierspayments.totalPaidAmount, 0))) AS totalRemainingForSuppliers
          FROM suppliersorders
          LEFT JOIN (
              SELECT 
                  orderid,
                  SUM(amount) AS totalPaidAmount
              FROM suppliersorderspayments
              GROUP BY orderid
          ) AS supplierspayments ON suppliersorders.id = supplierspayments.orderid;
      `;
      db.query(query, (err, result) => {
          if (err) reject(err);
          else resolve(result[0].totalRemainingForSuppliers || 0);
      });
  });
}

// Endpoint to get the financial report
router.get("/getFinancialReport", async function (req, res) {
  try {
      const [
          totalPaymentsReceived,
          totalExpenses,
          totalOutstandingAmounts,
          totalSupplierPayments,
          totalSupplierOrders,
          totalSales,
          totalQuantityOfItemsSold,
          salesByCategory,
          salesByCity,
          averageOrderValue,
          topSellingProducts,
          salesByMonth,
          salesByDayOfWeek,
          customerPurchaseFrequency,
          topCustomersByRevenue,
          salesByCategoryOverTime,
          discountImpactOnSales,
          profitMarginAnalysis,
          salesByCoupon,
          totalProducts,
          totalCustomers,
          totalRemainingForSuppliers
      ] = await Promise.all([
          calculateTotalPaymentsReceived(),
          calculateTotalExpenses(),
          calculateTotalOutstandingAmounts(),
          calculateTotalSupplierPayments(),
          calculateTotalSupplierOrders(),
          calculateTotalSales(),
          calculateTotalQuantityOfItemsSold(),
          calculateSalesByCategory(),
          calculateSalesByCity(),
          calculateAverageOrderValue(),
          calculateTopSellingProducts(),
          calculateSalesByMonth(),
          calculateSalesByDayOfWeek(),
          calculateCustomerPurchaseFrequency(),
          calculateTopCustomersByRevenue(),
          calculateSalesByCategoryOverTime(),
          calculateDiscountImpactOnSales(),
          calculateProfitMarginAnalysis(),
          calculateSalesByCoupon(),
          calculateTotalProducts(),
          calculateTotalCustomers(),
          calculateTotalRemainingForSuppliers()
      ]);

      const financialReport = {
          totalPaymentsReceived,
          totalExpenses,
          totalOutstandingAmounts,
          totalSupplierPayments,
          totalSupplierOrders,
          totalSales,
          totalQuantityOfItemsSold,
          salesByCategory,
          salesByCity,
          averageOrderValue,
          topSellingProducts,
          salesByMonth,
          salesByDayOfWeek,
          customerPurchaseFrequency,
          topCustomersByRevenue,
          salesByCategoryOverTime,
          discountImpactOnSales,
          profitMarginAnalysis,
          salesByCoupon,
          totalProducts,
          totalCustomers,
          totalRemainingForSuppliers
      };

      res.send({
          status: "success",
          data: financialReport
      });
  } catch (error) {
      console.error('Error generating financial report:', error);
      res.status(500).send({
          status: "error",
          msg: "Error generating financial report"
      });
  }
});

router.get("/getExpenses",userMiddleware.isSuperAdmin, function (req, res) {
  db.query(
    `select * from expenses order by id desc`,
    (err, result) => {
      if (err) {
        res.send({
          status:"err",
          msg:err
        })      } else {
        res.send({
          status:"success",
          data:result
        })
      }
    }
  );
});
router.get("/getSuppliersOrderPayments",userMiddleware.isSuperAdmin, function (req, res) {
  db.query(
    `select * from suppliersorderspayments where orderid=? order by id desc`,[req.query.orderId],
    (err, result) => {
      if (err) {
        console.error(err)
      } else {
        res.send({
          status:"success",
          data:result
        })
      }
    }
  );
});
router.get("/getSuppliersOrderAttachments",userMiddleware.isSuperAdmin, function (req, res) {
  db.query(
    `select * from suppliersordersattachments where orderid=? order by id desc`,[req.query.orderId],
    (err, result) => {
      if (err) {
        console.error(err)
      } else {
        res.send({
          status:"success",
          data:result
        })
      }
    }
  );
});
router.get("/deleteSuppliersOrderAttachment",userMiddleware.isSuperAdmin, function (req, res) {
  db.query(
    `delete from suppliersordersattachments where id=?`,[req.query.id],
    (err, result) => {
      if (err) {
        console.error(err)
        res.status(400).send({
          status:"error",
          msg:err
        })
      } else {
        res.send({
          status:"success",
          msg:"Attachment Deleted"
        })
      }
    }
  );
});
router.get("/getSuppliersPayments",userMiddleware.isSuperAdmin, function (req, res) {
  db.query(
    `SELECT 
    sop.id AS id,
    sop.amount AS payment_amount,
    sop.dateadded AS payment_date,
    sop.notes AS payment_notes
FROM 
    suppliers s
JOIN 
    suppliersorders so ON s.id = so.supplier
JOIN 
    suppliersorderspayments sop ON so.id = sop.orderid
WHERE 
    s.id = ?
    order by sop.id
`,[req.query.supplierId],
    (err, result) => {
      if (err) {
        res.send({
          status:"err",
          msg:err
        })
      } else {
        res.send({
          status:"success",
          data:result
        })
      }
    }
  );
});
router.get("/getSuppliers",userMiddleware.isSuperAdmin, function (req, res) {
  db.query(
    `SELECT 
    s.id AS id,
    s.name AS supplier_name,
    s.mobile AS supplier_mobile,
    s.company AS supplier_company,
    s.country AS supplier_country,
    s.email AS supplier_email,
    IFNULL(so.total_order_amount, 0) AS total_order_amount,
    IFNULL(sop.total_payment_amount, 0) AS total_payment_amount,
    IFNULL(so.total_order_amount, 0) - IFNULL(sop.total_payment_amount, 0) AS total_remaining_amount
FROM 
    suppliers s
LEFT JOIN 
    (
        SELECT 
            supplier,
            SUM(amount) AS total_order_amount
        FROM 
            suppliersorders
        GROUP BY 
            supplier
    ) so ON s.id = so.supplier
LEFT JOIN 
    (
        SELECT 
            so.supplier,
            SUM(sop.amount) AS total_payment_amount
        FROM 
            suppliersorderspayments sop
        JOIN 
            suppliersorders so ON sop.orderid = so.id
        GROUP BY 
            so.supplier
    ) sop ON s.id = sop.supplier;

`,
    (err, result) => {
      if (err) {
        console.error(err)
      } else {
        res.send({
          status:"success",
          data:result
        })
      }
    }
  );
});
router.get("/getSuppliersOrders", userMiddleware.isSuperAdmin, function (req, res) {
  db.query(
    `SELECT suppliersorders.*, suppliersorders.id as orderId, suppliers.*, 
            IFNULL(SUM(suppliersorderspayments.amount), 0) as totalPaid,
            (suppliersorders.amount - IFNULL(SUM(suppliersorderspayments.amount), 0)) as totalRemaining
     FROM suppliersorders 
     INNER JOIN suppliers ON suppliersorders.supplier = suppliers.id
     LEFT JOIN suppliersorderspayments ON suppliersorders.id = suppliersorderspayments.orderid
     GROUP BY suppliersorders.id, suppliers.id
     ORDER BY suppliersorders.id DESC`,
    (err, result) => {
      if (err) {
        res.send({
          status: "err",
          msg: err
        });
      } else {
        res.send({
          status: "success",
          data: result
        });
      }
    }
  );
});

router.post("/editOrderPayment",userMiddleware.isSuperAdmin, function (req, res) {
  const {
    notes,id
  }=req.body
  db.query(
    `update orderspayments set notes=? where id=?`,[notes,id],
    (err, result) => {
      if (err) {
        console.log(err)
      } else {
        res.send({
          status: "success",
          msg: "Payment Edited",
        });
      }
    }
  );

});
router.post("/editSupplier",userMiddleware.isSuperAdmin, function (req, res) {
  const {
    name,mobile,company,country,email,id
  }=req.body
  db.query(
    `update suppliers set name=?,mobile=?,company=?,country=?,email=? where id=?`,[name,mobile,company,country,email,id],
    (err, result) => {
      if (err) {
        console.log(err)
      } else {
        res.send({
          status: "success",
          msg: "Supplier Edited",
        });
      }
    }
  );

});
router.post("/editSupplierOrder",userMiddleware.isSuperAdmin, function (req, res) {
  const {
    amount,id
  }=req.body
  db.query(
    `update suppliersorders set amount=? where id=?`,[ amount,id],
    (err, result) => {
      if (err) {
        console.log(err)
      } else {
        res.send({
          status: "success",
          msg: "Order Edited",
        });
      }
    }
  );

});
router.post("/editSupplierOrderPayment",userMiddleware.isSuperAdmin, function (req, res) {
  const {
    notes,id
  }=req.body
  db.query(
    `update suppliersorderspayments set notes=? where id=?`,[ notes,id],
    (err, result) => {
      if (err) {
        console.log(err)
      } else {
        res.send({
          status: "success",
          msg: "Payment Edited",
        });
      }
    }
  );

});
router.get("/deleteOrderPayment",userMiddleware.isSuperAdmin, function (req, res) {
  const {
   id
  }=req.query
  db.query(
    `delete from orderspayments where id=?`,[id],
    (err, result) => {
      if (err) {
        console.log(err)
      } else {
        res.send({
          status: "success",
          msg: "Payment Deleted",
        });
      }
    }
  );

});
router.get("/deleteSupplierOrder",userMiddleware.isSuperAdmin, function (req, res) {
  const {
   id
  }=req.query
  db.query(
    `delete from suppliersorders where id=?`,[id],
    (err, result) => {
      if (err) {
        console.log(err)
      } else {
        res.send({
          status: "success",
          msg: "Order Deleted",
        });
      }
    }
  );

});
router.get("/getStats",userMiddleware.isSuperAdmin, function (req, res) {
  db.query(
    `SELECT
    (SELECT COUNT(id) FROM products) AS productsCount,
    (SELECT COUNT(id) FROM customers) AS customersCount,
    (SELECT COUNT(id) FROM cities) AS citiesCount,
    (SELECT COUNT(id) FROM coupons) AS couponsCount;
`,
    (err, result) => {
      if (err) {
        console.log(err)
      } else {
        const stats=[
          {
            title:"عدد المنتجات",
            value:result[0].productsCount,
            color:"#ee6055",
            buttonText:"مشاهدة الكل"
          },
          {
            title:"عدد الزبائن",
            value:result[0].customersCount,
            color:"#60d394",
            buttonText:"مشاهدة الكل"
          },
          {
            title:"عدد المدن",
            value:result[0].citiesCount,
            color:"#aaf683",
            buttonText:"مشاهدة الكل"
          },
          {
            title:"عدد الكوبونات",
            value:result[0].couponsCount,
            color:"#ffd97d",
            buttonText:"مشاهدة الكل"
          }
        ]
        res.send({
          status: "success",
          data: stats,
        });
      }
    }
  );

});
router.get("/getCart", function (req, res) {
  if(req.query.id){
  db.query(
    `select * from cart where cartId =?`,[req.query.id],
    (err, result) => {
      if (err) {
        console.log(err)
      } else {
      
        result.forEach(r => {
          r.total=r.price*r.quantity
        });
        res.send({
          status: "success",
          data: result,
        });
      }
    }
  );
  }
  else{
    res.send({
      status: "success",
      data: [],
    });
  }


});
router.get("/getCartCustomer",userMiddleware.isLoggedInOrNot, function (req, res) {
  if(req.query.id){
  db.query(
    `select * from cart where cartId =?`,[req.query.id],
    (err, result) => {
      if (err) {
        console.log(err)
      } else {
      
        result.forEach(r => {
          r.total=r.price*r.quantity
        });
        res.send({
          status: "success",
          data: result,
        });
      }
    }
  );
  }
  else{
    if(req.userData.userId){
      db.query(
        `select * from cart where (user=? and orderNumber IS NULL) order by id desc`,[req.userData.userId],
        (err,result)=>{
          if(err){

          }
          else{
            if(result.length>0){
              db.query(
                `select * from cart where cartId =?`,[result[0].cartId],
                (err, result) => {
                  if (err) {
                    console.log(err)
                  } else {
                  
                    result.forEach(r => {
                      r.total=r.price*r.quantity
                    });
                    res.send({
                      status: "success",
                      data: result,
                    });
                  }
                }
              );
            }
            else{
              res.send({
                status: "success",
                data: [],
              });
            }
          }
        }
      
      )
    }
    else{
       res.send({
      status: "success",
      data: [],
    });
    }
   
  }


});
router.get("/getPendingCarts",userMiddleware.isSuperAdmin, function (req, res) {
  db.query(
    `select cartId from cart where orderNumber IS NULL order by id desc`,
    (err, array) => {
      if (err) {
        console.log(err)
      } else {
        const uniqueArray = array.reduce((acc, current) => {
          const x = acc.find(item => item.cartId === current.cartId);
          if (!x) {
              return acc.concat([current]);
          } else {
              return acc;
          }
      }, []);
        res.send({
          status: "success",
          data: uniqueArray,
        });
      }
    }
  );

});
router.get("/getCityPrice",userMiddleware.isSuperAdmin, function (req, res) {
  db.query(
    `select price from cities where name=?`,[req.query.name],
    (err, array) => {
      if (err) {
        console.log(err)
      } else {
      
        res.send({
          status: "success",
          price: array.length>0?array[0].price:null,
        });
      }
    }
  );

});
router.post("/addToCartById",userMiddleware.isSuperAdmin, function (req, res) {
  const {
   cartId,productId,priceType
  }=req.body
  db.query(
    `select * from cart where (cartId=? and orderNumber IS NOT NULL)`,[cartId],
    (err, result) => {
      if (err) {
        console.log(err)
        res.send({
          status:"error",
          msg:err
        })
      } else {
        if(result.length>0){
          res.send({
            status:"error",
            msg:"لا يمكن اضافة منتجات لهذه السلة"
          })
        }
        else{
          db.query(
            `select * from products where (id=? and quantity>0)`,[productId],
            (err, product) => {
              if (err) {
                console.log(err)
                res.send({
                  status:"error",
                  msg:err
                })
              } else {
                if(product.length>0){
                     db.query(
                  `insert into cart (cartId, productItemNumber,productId,image,name,quantity,unit,price,barcode) values(?,?,?,?,?,?,?,?,?)`,[cartId,product[0].itemno,product[0].id,product[0].image,product[0].name,1,product[0].unit,priceType==0?product[0].price1:priceType==1?product[0].price2:priceType==2?product[0].price3:product[0].price1,product[0].barcode],
                  (err, result) => {
                    if (err) {
                      console.log(err)
                      res.send({
                        status:"error",
                        msg:err
                      })
                    } else {
                 res.send({
                  status:"success",
                  msg:"تم اضافة المنتج الى السلة بنجاح"
                 })
                    }
                  }
                );  
                }
                else{
                  res.send({
                    status:"error",
                    msg:"هذا المنتج غير موجود او لا يوجد كمية كافية"
                   })
                }
           
              }
            }
          );
        }
  
      }
    }
  );


});
router.post("/addToCartCustomer",userMiddleware.isLoggedInOrNot, function (req, res) {
  const {
   cartId,productId,quantity,selectedProperties
  }=req.body

  if(req.userData.userId){
    db.query(
      `select pricetype from customers where (id=?)`,[req.userData.userId],
      (err, pricetype) => {
        if(err){

        }
      
    if(cartId){

      db.query(
        `select * from cart where (user=? and cartId=? and orderNumber IS NOT NULL) order by id desc`,[req.userData.userId,cartId],
        (err, result) => {
          if(err){

          }
          else{
            if(result.length>0){
              const newCart=generateRandomId(7)
              db.query(
                `select * from products where (id=? and quantity>0)`,[productId],
                (err, product) => {
                  if (err) {
                    console.log(err)
                    res.send({
                      status:"error",
                      msg:err
                    })
                  } else {
                    if(product.length>0){
                         db.query(
                      `insert into cart (cartId, productItemNumber,productId,image,name,quantity,unit,price,barcode,user) values(?,?,?,?,?,?,?,?,?,?)`,[newCart,product[0].itemno,product[0].id,product[0].image,product[0].name,quantity,product[0].unit,pricetype[0]==0?product[0].price1:pricetype[0]==1?product[0].price2:pricetype[0]==2?product[0].price3:product[0].price1,product[0].barcode,req.userData.userId],
                      (err, result) => {
                        if (err) {
                          console.log(err)
                          res.send({
                            status:"error",
                            msg:err
                          })
                        } else {
                     res.send({
                      status:"success",
                      msg:"تم اضافة المنتج الى السلة بنجاح",
                      newCart
                     })

                     selectedProperties.forEach(property => {
                      db.query(`insert into cartoptions (cart,label,optionvalue) values(?,?,?)`,[result.insertId,property.label,property.value]),(err,result)=>{
                        if(err){
                          console.error(err)
                        }
                      }

                     });
                        }
                      }
                    );  
                    }
                    else{
                      res.send({
                        status:"error",
                        msg:"هذا المنتج غير موجود او لا يوجد كمية كافية"
                       })
                    }
               
                  }
                }
              );


            }
              
              else{
                db.query(
                  `select * from products where (id=? and quantity>0)`,[productId],
                  (err, product) => {
                    if (err) {
                      console.log(err)
                      res.send({
                        status:"error",
                        msg:err
                      })
                    } else {
                      if(product.length>0){
                           db.query(
                        `insert into cart (cartId, productItemNumber,productId,image,name,quantity,unit,price,barcode,user) values(?,?,?,?,?,?,?,?,?,?)`,[cartId,product[0].itemno,product[0].id,product[0].image,product[0].name,quantity,product[0].unit,pricetype[0]==0?product[0].price1:pricetype[0]==1?product[0].price2:pricetype[0]==2?product[0].price3:product[0].price1,product[0].barcode,req.userData.userId],
                        (err, result) => {
                          if (err) {
                            console.log(err)
                            res.send({
                              status:"error",
                              msg:err
                            })
                          } else {
                       res.send({
                        status:"success",
                        msg:"تم اضافة المنتج الى السلة بنجاح",
                        newCart:cartId
                       })
                       selectedProperties.forEach(property => {
                        db.query(`insert into cartoptions (cart,label,optionvalue) values(?,?,?)`,[result.insertId,property.label,property.value]),(err,result)=>{
                          if(err){
                            console.error(err)
                          }
                        }
  
                       });
                          }
                        }
                      );  
                      }
                      else{
                        res.send({
                          status:"error",
                          msg:"هذا المنتج غير موجود او لا يوجد كمية كافية"
                         })
                      }
                 
                    }
                  }
                );
  
              }
                        
           
          }

        })
     
    }
    else{

      db.query(
        `select * from cart where (user=? and orderNumber IS NULL) order by id desc`,[req.userData.userId],
        (err, result) => {
          if(err){

          }
          else{
            if(result.length>0){
              const newCart=result[0].cartId
              db.query(
                `select * from products where (id=? and quantity>0)`,[productId],
                (err, product) => {
                  if (err) {
                    console.log(err)
                    res.send({
                      status:"error",
                      msg:err
                    })
                  } else {
                    if(product.length>0){
                         db.query(
                      `insert into cart (cartId, productItemNumber,productId,image,name,quantity,unit,price,barcode,user) values(?,?,?,?,?,?,?,?,?,?)`,[newCart,product[0].itemno,product[0].id,product[0].image,product[0].name,quantity,product[0].unit,pricetype[0]==0?product[0].price1:pricetype[0]==1?product[0].price2:pricetype[0]==2?product[0].price3:product[0].price1,product[0].barcode,req.userData.userId],
                      (err, result) => {
                        if (err) {
                          console.log(err)
                          res.send({
                            status:"error",
                            msg:err
                          })
                        } else {
                     res.send({
                      status:"success",
                      msg:"تم اضافة المنتج الى السلة بنجاح",
                      newCart
                     })
                     selectedProperties.forEach(property => {
                      db.query(`insert into cartoptions (cart,label,optionvalue) values(?,?,?)`,[result.insertId,property.label,property.value]),(err,result)=>{
                        if(err){
                          console.error(err)
                        }
                      }

                     });
                        }
                      }
                    );  
                    }
                    else{
                      res.send({
                        status:"error",
                        msg:"هذا المنتج غير موجود او لا يوجد كمية كافية"
                       })
                    }
               
                  }
                }
              );


            }
              
              else{

                
                const newCart=generateRandomId(7)
                db.query(
                `select * from products where (id=? and quantity>0)`,[productId],
                (err, product) => {
                  if (err) {
                    console.log(err)
                    res.send({
                      status:"error",
                      msg:err
                    })
                  } else {
                    if(product.length>0){
                         db.query(
                      `insert into cart (cartId, productItemNumber,productId,image,name,quantity,unit,price,barcode,user) values(?,?,?,?,?,?,?,?,?,?)`,[newCart,product[0].itemno,product[0].id,product[0].image,product[0].name,quantity,product[0].unit,pricetype[0]==0?product[0].price1:pricetype[0]==1?product[0].price2:pricetype[0]==2?product[0].price3:product[0].price1,product[0].barcode,req.userData.userId],
                      (err, result) => {
                        if (err) {
                          console.log(err)
                          res.send({
                            status:"error",
                            msg:err
                          })
                        } else {
                     res.send({
                      status:"success",
                      msg:"تم اضافة المنتج الى السلة بنجاح",
                      newCart
                     })
                     selectedProperties.forEach(property => {
                      db.query(`insert into cartoptions (cart,label,optionvalue) values(?,?,?)`,[result.insertId,property.label,property.value]),(err,result)=>{
                        if(err){
                          console.error(err)
                        }
                      }

                     });
                        }
                      }
                    );  
                    }
                    else{
                      res.send({
                        status:"error",
                        msg:"هذا المنتج غير موجود او لا يوجد كمية كافية"
                       })
                    }
               
                  }
                }
              );


        
                  }
                        
           
          }

        })


    }
  })
  }
  else{
    if(cartId){


      db.query(
        `select * from cart where ( cartId=? and orderNumber IS NOT NULL) order by id desc`,[cartId],
        (err, result) => {
          if(err){

          }
          else{
            if(result.length>0){
              const newCart=generateRandomId(7)
              db.query(
                `select * from products where (id=? and quantity>0)`,[productId],
                (err, product) => {
                  if (err) {
                    console.log(err)
                    res.send({
                      status:"error",
                      msg:err
                    })
                  } else {
                    if(product.length>0){
                         db.query(
                      `insert into cart (cartId, productItemNumber,productId,image,name,quantity,unit,price,barcode) values(?,?,?,?,?,?,?,?,?)`,[newCart,product[0].itemno,product[0].id,product[0].image,product[0].name,quantity,product[0].unit,product[0].price1,product[0].barcode],
                      (err, result) => {
                        if (err) {
                          console.log(err)
                          res.send({
                            status:"error",
                            msg:err
                          })
                        } else {
                     res.send({
                      status:"success",
                      msg:"تم اضافة المنتج الى السلة بنجاح",
                      newCart
                     })
                     selectedProperties.forEach(property => {
                      db.query(`insert into cartoptions (cart,label,optionvalue) values(?,?,?)`,[result.insertId,property.label,property.value]),(err,result)=>{
                        if(err){
                          console.error(err)
                        }
                      }

                     });
                        }
                      }
                    );  
                    }
                    else{
                      res.send({
                        status:"error",
                        msg:"هذا المنتج غير موجود او لا يوجد كمية كافية"
                       })
                    }
               
                  }
                }
              );


            }
              
              else{
                db.query(
                  `select * from products where (id=? and quantity>0)`,[productId],
                  (err, product) => {
                    if (err) {
                      console.log(err)
                      res.send({
                        status:"error",
                        msg:err
                      })
                    } else {
                      if(product.length>0){
                           db.query(
                        `insert into cart (cartId, productItemNumber,productId,image,name,quantity,unit,price,barcode) values(?,?,?,?,?,?,?,?,?)`,[cartId,product[0].itemno,product[0].id,product[0].image,product[0].name,quantity,product[0].unit,product[0].price1,product[0].barcode],
                        (err, result) => {
                          if (err) {
                            console.log(err)
                            res.send({
                              status:"error",
                              msg:err
                            })
                          } else {
                       res.send({
                        status:"success",
                        msg:"تم اضافة المنتج الى السلة بنجاح",
                        newCart:cartId
                       })
                       selectedProperties.forEach(property => {
                        db.query(`insert into cartoptions (cart,label,optionvalue) values(?,?,?)`,[result.insertId,property.label,property.value]),(err,result)=>{
                          if(err){
                            console.error(err)
                          }
                        }
  
                       });
                          }
                        }
                      );  
                      }
                      else{
                        res.send({
                          status:"error",
                          msg:"هذا المنتج غير موجود او لا يوجد كمية كافية"
                         })
                      }
                 
                    }
                  }
                );
  
              }
                        
           
          }

        })
     
  
































     
    }
    else{

     
      const newCart=generateRandomId(7)
      db.query(
        `select * from products where (id=? and quantity>0)`,[productId],
        (err, product) => {
          if (err) {
            console.log(err)
            res.send({
              status:"error",
              msg:err
            })
          } else {
            if(product.length>0){
                 db.query(
              `insert into cart (cartId, productItemNumber,productId,image,name,quantity,unit,price,barcode) values(?,?,?,?,?,?,?,?,?)`,[newCart,product[0].itemno,product[0].id,product[0].image,product[0].name,quantity,product[0].unit,product[0].price1,product[0].barcode],
              (err, result) => {
                if (err) {
                  console.log(err)
                  res.send({
                    status:"error",
                    msg:err
                  })
                } else {
             res.send({
              status:"success",
              msg:"تم اضافة المنتج الى السلة بنجاح",
              newCart
             })
             selectedProperties.forEach(property => {
              db.query(`insert into cartoptions (cart,label,optionvalue) values(?,?,?)`,[result.insertId,property.label,property.value]),(err,result)=>{
                if(err){
                  console.error(err)
                }
              }

             });
                }
              }
            );  
            }
            else{
              res.send({
                status:"error",
                msg:"هذا المنتج غير موجود او لا يوجد كمية كافية"
               })
            }
       
          }
        }
      );


   

    }

  }


});
router.post("/addToCartByBarcode",userMiddleware.isSuperAdmin, function (req, res) {
  const {
   cartId,barcode,priceType
  }=req.body
  db.query(
    `select * from cart where (cartId=? and orderNumber IS NOT NULL)`,[cartId],
    (err, result) => {
      if (err) {
        console.log(err)
        res.send({
          status:"error",
          msg:err
        })
      } else {
        if(result.length>0){
          res.send({
            status:"error",
            msg:"لا يمكن اضافة منتجات لهذه السلة"
          })
        }
        else{
          db.query(
            `select * from products where ((barcode=? or itemno=?) and quantity>0)`,[barcode,barcode],
            (err, product) => {
              if (err) {
                console.log(err)
                res.send({
                  status:"error",
                  msg:err
                })
              } else {
                if(product.length>0){
                  db.query(
                    `insert into cart (cartId, productItemNumber,productId,image,name,quantity,unit,price,barcode) values(?,?,?,?,?,?,?,?,?)`,[cartId,product[0].itemno,product[0].id,product[0].image,product[0].name,1,product[0].unit,priceType==0?product[0].price1:priceType==1?product[0].price2:priceType==2?product[0].price3:product[0].price1,product[0].barcode],
                    (err, result) => {
                      if (err) {
                        console.log(err)
                        res.send({
                          status:"error",
                          msg:err
                        })
                      } else {
                   res.send({
                    status:"success",
                    msg:"تم اضافة المنتج الى السلة بنجاح"
                   })
                      }
                    }
                  );
                }
                else{
                  res.send({
                    status:"error",
                    msg:"هذا المنتج غير موجود او لا يوجد كمية كافية"
                   })
                }
           
              }
            }
          );
        }
  
      }
    }
  );


});
router.get("/deleteFromCart", function (req, res) {
  db.query(
    `delete from cart where (id=? and orderNumber IS NULL)`,[req.query.id],
    (err, result) => {
      if (err) {
        console.log(err)
      } else {
        res.send({
          status: "success",
          msg: "تم حذف المنتج من السلة بنجاح",
        });
      }
    }
  );

});
router.get("/editCartQuantity", function (req, res) {
  db.query(
    `update cart set quantity=? where (id =? and orderNumber IS NULL)`,[req.query.quantity,req.query.cartId],
    (err, result) => {
      if (err) {
        console.log(err)
      } else {
        res.send({
          status: "success",
          msg: "تم تعديل الكمية بنجاح",
        });
      }
    }
  );

});
router.get("/deleteOrder",userMiddleware.isSuperAdmin, function (req, res) {
  db.query(
    `delete from orders where id=?`,[req.query.id],
    (err, result) => {
      if (err) {
        console.log(err)
      } else {
        res.send({
          status: "success",
          msg: "تم حذف الطلبية بنجاح",
        });
      }
    }
  );

});
function generateRandomId(length) {
  const charset = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
  let id = "";
  for (let i = 0; i < length; i++) {
    const randomIndex = Math.floor(Math.random() * charset.length);
    id += charset[randomIndex];
  }
  return id;
}
function getOrderDetails(orderNumber) {
  return new Promise((resolve, reject) => {
    // Fetch order details from the orders table
    db.query(`SELECT * FROM orders WHERE orderNumber = ?`, [orderNumber], (err, orderResult) => {
      if (err) {
        reject(err);
        return;
      }

      // Fetch cart items for the order from the cart table
      db.query(`SELECT * FROM cart WHERE orderNumber = ?`, [orderNumber], (err, cartResult) => {
        if (err) {
          reject(err);
          return;
        }

        // Fetch cart options for the cart items
        const cartIds = cartResult.map(item => item.id);
        db.query(`SELECT * FROM cartoptions WHERE cart IN (?)`, [cartIds], (err, optionsResult) => {
          if (err) {
            reject(err);
            return;
          }

          // Group options by cart
          const cartOptions = cartResult.map(cartItem => {
            cartItem.options = optionsResult
              .filter(option => option.cart === cartItem.id)
              .map(option => ({ label: option.label, value: option.optionvalue }));
            return cartItem;
          });

          // Calculate subtotal amount
          let subtotalAmount = 0;
          for (const item of cartResult) {
            subtotalAmount += item.price * item.quantity;
          }

          // Calculate total amount after applying coupon and discount
          let totalAmount = subtotalAmount;
          let couponDiscount = 0;
          const couponType = orderResult[0].couponType;
          const couponValue = orderResult[0].couponValue || 0;
          const shipping = orderResult[0].shipping || 0;
          const discount = orderResult[0].discount || 0;

          if (couponType === 'ثابت') {
            totalAmount -= couponValue;
            couponDiscount = couponValue;
          } else if (couponType === 'نسبة مئوية') {
            const couponPercentageDiscount = subtotalAmount * (couponValue / 100);
            totalAmount -= couponPercentageDiscount;
            couponDiscount = couponPercentageDiscount;
          }

          totalAmount += shipping;
          totalAmount -= discount;

          // Fetch paid amount for the order from orderspayments table
          db.query(`SELECT SUM(amount) AS paidAmount FROM orderspayments WHERE orderId = ?`, [orderNumber], (err, paymentResult) => {
            if (err) {
              reject(err);
              return;
            }

            // Calculate remaining unpaid amount
            const paidAmount = paymentResult[0].paidAmount || 0;
            const remainingAmount = totalAmount - paidAmount;

            // Resolve with order details including subtotal amount, total amount, coupon discount, remaining unpaid amount, and cart items
            const orderDetails = {
              id: orderResult[0].id,
              orderNumber: orderResult[0].orderNumber,
              userId: orderResult[0].userId,
              city: orderResult[0].city,
              address: orderResult[0].address,
              mobile: orderResult[0].mobile,
              coupon: orderResult[0].coupon,
              couponType: orderResult[0].couponType,
              couponValue: orderResult[0].couponValue,
              date_added: orderResult[0].date_added,
              discount,
              shipping,
              customerName: orderResult[0].customerName,
              source: orderResult[0].source,
              subtotalAmount,
              totalAmount,
              couponDiscount,
              paidAmount,
              remainingAmount,
              cart: cartOptions
            };

            resolve(orderDetails);
          });
        });
      });
    });
  });
}
function getOrderDetailsUser(orderNumber,userId) {
  return new Promise((resolve, reject) => {
    // Fetch order details from the orders table
    db.query(`SELECT * FROM orders WHERE (orderNumber = ? and userId=?)`, [orderNumber,userId], (err, orderResult) => {
      if (err) {
        reject(err);
        return;
      }

      // Fetch cart items for the order from the cart table
      db.query(`SELECT * FROM cart WHERE orderNumber = ?`, [orderNumber], (err, cartResult) => {
        if (err) {
          reject(err);
          return;
        }

        // Fetch cart options for the cart items
        const cartIds = cartResult.map(item => item.id);
        db.query(`SELECT * FROM cartoptions WHERE cart IN (?)`, [cartIds], (err, optionsResult) => {
          if (err) {
            reject(err);
            return;
          }

          // Group options by cart
          const cartOptions = cartResult.map(cartItem => {
            cartItem.options = optionsResult
              .filter(option => option.cart === cartItem.id)
              .map(option => ({ label: option.label, value: option.optionvalue }));
            return cartItem;
          });

          // Calculate subtotal amount
          let subtotalAmount = 0;
          for (const item of cartResult) {
            subtotalAmount += item.price * item.quantity;
          }

          // Calculate total amount after applying coupon and discount
          let totalAmount = subtotalAmount;
          let couponDiscount = 0;
          const couponType = orderResult[0].couponType;
          const couponValue = orderResult[0].couponValue || 0;
          const shipping = orderResult[0].shipping || 0;
          const discount = orderResult[0].discount || 0;

          if (couponType === 'ثابت') {
            totalAmount -= couponValue;
            couponDiscount = couponValue;
          } else if (couponType === 'نسبة مئوية') {
            const couponPercentageDiscount = subtotalAmount * (couponValue / 100);
            totalAmount -= couponPercentageDiscount;
            couponDiscount = couponPercentageDiscount;
          }

          totalAmount += shipping;
          totalAmount -= discount;

          // Fetch paid amount for the order from orderspayments table
          db.query(`SELECT SUM(amount) AS paidAmount FROM orderspayments WHERE orderId = ?`, [orderNumber], (err, paymentResult) => {
            if (err) {
              reject(err);
              return;
            }

            // Calculate remaining unpaid amount
            const paidAmount = paymentResult[0].paidAmount || 0;
            const remainingAmount = totalAmount - paidAmount;

            // Resolve with order details including subtotal amount, total amount, coupon discount, remaining unpaid amount, and cart items
            const orderDetails = {
              id: orderResult[0].id,
              orderNumber: orderResult[0].orderNumber,
              userId: orderResult[0].userId,
              city: orderResult[0].city,
              address: orderResult[0].address,
              mobile: orderResult[0].mobile,
              coupon: orderResult[0].coupon,
              couponType: orderResult[0].couponType,
              couponValue: orderResult[0].couponValue,
              date_added: orderResult[0].date_added,
              discount,
              shipping,
              customerName: orderResult[0].customerName,
              source: orderResult[0].source,
              subtotalAmount,
              totalAmount,
              couponDiscount,
              paidAmount,
              remainingAmount,
              cart: cartOptions
            };

            resolve(orderDetails);
          });
        });
      });
    });
  });
}

function getCustomerAccountStatement(customerId) {
  return new Promise((resolve, reject) => {
    // Fetch orders and payments for the customer
    const query = `
      SELECT o.id AS orderId, o.orderNumber, o.userId, o.city, o.address, o.mobile, 
             o.coupon, o.couponType, o.couponValue, o.discount, o.shipping, o.date_added, 
             o.customerName, o.source, op.amount AS paymentAmount, op.dateadded AS paymentDate, 
             op.notes AS paymentNotes
      FROM orders o
      LEFT JOIN orderspayments op ON o.orderNumber = op.orderId
      WHERE o.userId = ?;
    `;

    db.query(query, [customerId], (err, result) => {
      if (err) {
        reject(err);
        return;
      }

      // Process the results to format the account statement
      const accountStatement = [];
      const orders = new Map();

      result.forEach(row => {
        const orderId = row.orderId;
        if (!orders.has(orderId)) {
          orders.set(orderId, {
            orderId,
            orderNumber: row.orderNumber,
            userId: row.userId,
            city: row.city,
            address: row.address,
            mobile: row.mobile,
            coupon: row.coupon,
            couponType: row.couponType,
            couponValue: row.couponValue,
            discount: row.discount,
            shipping: row.shipping,
            customerName: row.customerName,
            source: row.source,
            date: row.date_added,
            totalAmount: 0,
            payments: [],
            cartDetails: []
          });
        }

        const order = orders.get(orderId);

        if (row.paymentAmount !== null) {
          order.payments.push({
            amount: row.paymentAmount,
            date: row.paymentDate,
            notes: row.paymentNotes
          });
        }
      });

      // Calculate the total amount for each order and get cart details
      const orderPromises = Array.from(orders.values()).map(order => {
        return new Promise((resolve, reject) => {
          db.query(`SELECT * FROM cart WHERE orderNumber = ?`, [order.orderNumber], (err, cartResult) => {
            if (err) {
              reject(err);
              return;
            }

            let subtotalAmount = 0;
            let cartDetails = "";
            for (const item of cartResult) {
              subtotalAmount += item.price * item.quantity;
              cartDetails += `• ${item.name} عدد ${item.quantity} * ${item.price} = ${item.quantity * item.price}<br>`;
            }

            let totalAmount = subtotalAmount;
            const couponType = order.couponType;
            const couponValue = order.couponValue || 0;
            const shipping = order.shipping || 0;
            const discount = order.discount || 0;

            let couponDiscount = 0;
            if (couponType === 'ثابت') {
              totalAmount -= couponValue;
              couponDiscount = couponValue;
            } else if (couponType === 'نسبة مئوية') {
              couponDiscount = (subtotalAmount * (couponValue / 100));
              totalAmount -= couponDiscount;
            }

            totalAmount += shipping;
            totalAmount -= discount;

            order.totalAmount = totalAmount;
           // order.cartDetails = `${cartDetails}${shipping?(`الشحن: ${shipping}<br>`):""}${discount?(`خصم: ${discount}<br>`):""}${couponDiscount?(`خصم الكوبون: ${couponDiscount}<br>`):""}`;

            resolve(order);
          });
        });
      });

      // Resolve the account statement with calculated totals
      Promise.all(orderPromises)
        .then(ordersWithTotals => {
          let totalOrderAmount = 0;
          let totalPaidAmount = 0;
          let balance = 0;

          ordersWithTotals.forEach(order => {
            const paidAmount = order.payments.reduce((sum, payment) => sum + payment.amount, 0);
            totalOrderAmount += order.totalAmount;
            totalPaidAmount += paidAmount;

            balance += order.totalAmount;
            accountStatement.push({
              description: "طلبية رقم " + order.orderNumber,
              date: order.date,
              plus:order.totalAmount,
              minus:"",
              notes: "",
              balance
            });
            order.payments.forEach(payment => {
              balance -= payment.amount;
              accountStatement.push({
                description: "دفعة عن طلبية رقم " + order.orderNumber,
                date: payment.date,
                plus:"",
                minus:payment.amount,
                notes: payment.notes,
                balance
              });
            });

          });

          const remainingAmount = totalOrderAmount - totalPaidAmount;
          accountStatement.sort((a, b) => new Date(a.date) - new Date(b.date));
          balance = 0;
          accountStatement.forEach((entry, index) => {
            if (index === 0) {
              
              balance = typeof entry.plus === 'number'?entry.plus:entry.minus*-1;

            } else {
              balance +=typeof entry.plus === 'number'?entry.plus:entry.minus*-1;
            }
            entry.balance = balance;
          });
          resolve({
            accountStatement,
            totalOrderAmount,
            totalPaidAmount,
            remainingAmount
          });
        })
        .catch(reject);
    });
  });
}


function getAllOrderDetails() {
  return new Promise((resolve, reject) => {
    // Fetch all order numbers
    db.query(`SELECT orderNumber FROM orders ORDER BY id DESC`, (err, orders) => {
      if (err) {
        reject(err);
        return;
      }

      // Array to store promises for each order
      const promises = [];

      // Iterate through each order number and fetch details
      for (const order of orders) {
        const orderNumber = order.orderNumber;
        const promise = getOrderDetails(orderNumber)
          .then((orderDetails) => {
            return orderDetails;
          })
          .catch((err) => {
            console.error('Error fetching details for order:', orderNumber);
            return null;
          });
        promises.push(promise);
      }

      // Resolve all promises once they are all settled
      Promise.all(promises)
        .then((results) => {
          // Filter out any null values (failed promises)
          const validResults = results.filter((result) => result !== null);
          resolve(validResults);
        })
        .catch((err) => {
          reject(err);
        });
    });
  });
}
function getAllOrderDetailsUser(userId) {
  return new Promise((resolve, reject) => {
    // Fetch all order numbers
    db.query(`SELECT orderNumber FROM orders where userId=? ORDER BY id DESC`,[userId], (err, orders) => {
      if (err) {
        reject(err);
        return;
      }

      // Array to store promises for each order
      const promises = [];

      // Iterate through each order number and fetch details
      for (const order of orders) {
        const orderNumber = order.orderNumber;
        const promise = getOrderDetails(orderNumber)
          .then((orderDetails) => {
            return orderDetails;
          })
          .catch((err) => {
            console.error('Error fetching details for order:', orderNumber);
            return null;
          });
        promises.push(promise);
      }

      // Resolve all promises once they are all settled
      Promise.all(promises)
        .then((results) => {
          // Filter out any null values (failed promises)
          const validResults = results.filter((result) => result !== null);
          resolve(validResults);
        })
        .catch((err) => {
          reject(err);
        });
    });
  });
}

router.get("/getOrderDetails",userMiddleware.isSuperAdmin,function(req,res) {
  const {orderId}=req.query

  getOrderDetails(orderId)
  .then((orderDetails) => {
    res.send(orderDetails)
  })
  .catch((err) => {
    console.error('Error:', err);
  });
})
router.get("/getOrderDetailsUser",userMiddleware.isLoggedIn,function(req,res) {
  const {orderId}=req.query

  getOrderDetailsUser(orderId,req.userData.userId)
  .then((orderDetails) => {
    res.send(orderDetails)
  })
  .catch((err) => {
    console.error('Error:', err);
  });
})
router.get("/getCustomerAccountStatement",userMiddleware.isSuperAdmin,function(req,res) {
  const {customerId}=req.query

  getCustomerAccountStatement(customerId)
  .then((CustomerAccountStatement) => {
    res.send(CustomerAccountStatement)
  })
  .catch((err) => {
    console.error('Error:', err);
  });
})

router.get("/getAllOrdersDetails",userMiddleware.isSuperAdmin,function(req,res) {
  getAllOrderDetails()
  .then((allOrderDetails) => {
  
    res.send(allOrderDetails)
  })
  .catch((err) => {
    console.error('Error:', err);
  });
})
router.get("/getAllOrdersDetailsUser",userMiddleware.isLoggedIn,function(req,res) {
  getAllOrderDetailsUser(req.userData.userId)
  .then((allOrderDetails) => {
  
    res.send(allOrderDetails)
  })
  .catch((err) => {
    console.error('Error:', err);
  });
})
router.post("/createOrder",userMiddleware.isSuperAdmin, function (req, res) {
  const {userId, city,address,mobile,coupon,discount,customerName,cartId,paidValue,addShipping}=req.body

  db.query(
    `select * from cart where (cartId=? and orderNumber IS NULL)`,[cartId],
    (err, result) => {
      if (err) {
        console.log(err)
      } else {
      if(result.length>0){
        db.query(
          `select * from coupons where (code =? and exp_date>CURRENT_TIMESTAMP and validity>0)`,[coupon],
          (err, result) => {
            if (err) {
              console.log(err)
            } else {
              const couponData=result[0]||null
              if(couponData){
                db.query(
                  `update coupons set validity=validity-1 where code=?`,[coupon]);
              }
              db.query(
                `select price from cities where name =?`,[city],
                (err, shippingPrice) => {
                  if (err) {
                    console.log(err)
                  } else {

                    const orderId=generateRandomId(10)
                    db.query(
                      `insert into orders (orderNumber,userId,city,address,mobile,coupon,couponType,couponValue,discount,customerName,source,shipping) values(?,?,?,?,?,?,?,?,?,?,?,?)`,[orderId,userId,city,address,mobile,coupon,result.length>0?result[0].coupontype:null,result.length>0?result[0].couponvalue:null,discount,customerName,"النظام",addShipping?shippingPrice[0].price:0],
                      (err, result) => {
                        if (err) {
                          console.log(err)
                        } else {
                          db.query(
                            `update cart set orderNumber=? where cartId=?`,[orderId,cartId],
                            (err, result) => {
                              if (err) {
                                console.log(err)
                              } else {
                                res.send({
                                  status: "success",
                                  msg: "تم انشاء الطلبية بنجاح",
                                });
                              }
                            }
                          );
                          db.query(
                            `select * from cart where cartId=?`,[cartId],
                            (err, result) => {
                              if (err) {
                                console.log(err)
                              } else {
                               result.forEach(r => {
                                db.query(
                                  `update products set quantity=quantity-? where (id=?)`,[r.quantity,r.productId]);
                               });


                               if(userId && paidValue)
                                db.query(
                                  `insert into orderspayments (amount,orderId) values(?,?)`,[paidValue,orderId],
                                  (err, result) => {
                                    if (err) {
                                      console.error(err)
                                    } else {
                                   
                                    }
                                  }
                                );
                                else if(paidValue!==0){
                                  let totalPrice=0
                                  result.forEach(product => {
                                    totalPrice+=(product.quantity*product.price)
                                  });
                                  if(couponData){
                                    console.error(couponData)

                                     let coupondiscount
                                     if(couponData.coupontype=="ثابت")
                                     coupondiscount=couponData.couponvalue
                                    else
                                    coupondiscount=(couponData.couponvalue*totalPrice/100)
                                     console.error(coupondiscount)
                                  totalPrice-=coupondiscount
                                  }
                                 totalPrice-=discount
                                  db.query(
                                    `insert into orderspayments (amount,orderId) values(?,?)`,[totalPrice,orderId],
                                    (err, result) => {
                                      if (err) {
                                        console.error(err)
                                      } else {
                                     
                                      }
                                    }
                                  );
                                }
                              }
                            }
                          );
                       
                        }
                      }
                    );

                  }
                
                }
                )
            
            }
          }
        );
      
      }
      else{
        res.send({
          status: "error",
          msg: "لا يمكن انشاء طلبية لهذه السلة"
        
        });
      }
      }
    }
  );


});
router.post("/createOrderCustomer",userMiddleware.isLoggedInOrNot, function (req, res) {
  var { city,address,mobile,coupon,customerName,cartId}=req.body
  var userId=null;
  if(req.userData.userId){
    console.error("user")

    userId=req.userData.userId

    db.query(
      `select * from cart where (user=? and orderNumber IS NULL) order by id desc`,[req.userData.userId],
      (err,result)=>{
        if(err){
          res.send({
            status:"error",
            err
          })
        }
        else{
          if(result.length>0){
            cartId=result[0].cartId
            db.query(
              `select * from cart where (cartId=? and orderNumber IS NULL)`,[cartId],
              (err, result) => {
                if (err) {
                  console.log(err)
                  res.send({
                    status:"error",
                    err
                  })
                } else {
                if(result.length>0){
                  db.query(
                    `select * from coupons where (code =? and exp_date>CURRENT_TIMESTAMP and validity>0)`,[coupon],
                    (err, result) => {
                      if (err) {
                        console.log(err)
                        res.send({
                          status:"error",
                          err
                        })
                      } else {
                        const couponData=result[0]||null
                        if(couponData){
                          db.query(
                            `update coupons set validity=validity-1 where code=?`,[coupon]);
                        }
                        db.query(
                          `select price from cities where name =?`,[city],
                          (err, shippingPrice) => {
                            if (err) {
                              console.log(err)
                              res.send({
                                status:"error",
                                err
                              })
                            } else {
          
                              const orderId=generateRandomId(10)
                              db.query(
                                `insert into orders (orderNumber,userId,city,address,mobile,coupon,couponType,couponValue,discount,customerName,source,shipping) values(?,?,?,?,?,?,?,?,?,?,?,?)`,[orderId,userId,city,address,mobile,coupon,result.length>0?result[0].coupontype:null,result.length>0?result[0].couponvalue:null,0,customerName,"السوق الالكتروني",shippingPrice[0].price],
                                (err, result) => {
                                  if (err) {
                                    console.log(err)
                                    res.send({
                                      status:"error",
                                      err
                                    })
                                  } else {
                                    db.query(
                                      `update cart set orderNumber=? where cartId=?`,[orderId,cartId],
                                      (err, result) => {
                                        if (err) {
                                          console.log(err)
                                          res.send({
                                            status:"error",
                                            err
                                          })
                                        } else {
                                          res.send({
                                            status: "success",
                                            msg: "تم انشاء الطلبية بنجاح",
                                          });
                                        }
                                      }
                                    );
                                    db.query(
                                      `select * from cart where cartId=?`,[cartId],
                                      (err, result) => {
                                        if (err) {
                                          console.log(err)
                                          res.send({
                                            status:"error",
                                            err
                                          })
                                        } else {
                                         result.forEach(r => {
                                          db.query(
                                            `update products set quantity=quantity-? where (id=?)`,[r.quantity,r.productId]);
                                         });
          
          
                                        
                                        }
                                      }
                                    );
                                 
                                  }
                                }
                              );
          
                            }
                          
                          }
                          )
                      
                      }
                    }
                  );
                
                }
                else{
                  res.send({
                    status: "error",
                    msg: "لا يمكن انشاء طلبية لهذه السلة"
                  
                  });
                }
                }
              }
            );
          }
        }
      }
    )

  }
  else{
    console.error("1")
    db.query(
      `select * from cart where (cartId=? and orderNumber IS NULL)`,[cartId],
      (err, result) => {
        if (err) {
          console.error(err)
          res.send({
            status:"error",
            err
          })
        } else {
          console.error("2")
        if(result.length>0){
          console.error("3")
          db.query(
            `select * from coupons where (code =? and exp_date>CURRENT_TIMESTAMP and validity>0)`,[coupon],
            (err, result) => {
              if (err) {
                res.send({
                  status:"error",
                  err
                })
                console.error(err)
              } else {
                console.error("4")
                const couponData=result[0]||null
                if(couponData){
                  console.error("5")
                  db.query(
                    `update coupons set validity=validity-1 where code=?`,[coupon]);
                }
                console.error("6")
                db.query(
                  `select price from cities where name =?`,[city],
                  (err, shippingPrice) => {
                    if (err) {
                      res.send({
                        status:"error",
                        err
                      })
                      console.error(err)
                    } else {
                      console.error("7")
                      const orderId=generateRandomId(10)
                      db.query(
                        `insert into orders (orderNumber,userId,city,address,mobile,coupon,couponType,couponValue,discount,customerName,source,shipping) values(?,?,?,?,?,?,?,?,?,?,?,?)`,[orderId,userId,city,address,mobile,coupon,result.length>0?result[0].coupontype:null,result.length>0?result[0].couponvalue:null,0,customerName,"السوق الالكتروني",shippingPrice[0].price],
                        (err, result) => {
                          if (err) {
                            res.send({
                              status:"error",
                              err
                            })
                            console.error(err)
                          } else {
                            console.error("8")
                            db.query(
                              `update cart set orderNumber=? where cartId=?`,[orderId,cartId],
                              (err, result) => {
                                if (err) {
                                  res.send({
                                    status:"error",
                                    err
                                  })
                                  console.error(err)
                                } else {
                                  res.send({
                                    status: "success",
                                    msg: "تم انشاء الطلبية بنجاح",
                                  });
                                }
                              }
                            );
                            db.query(
                              `select * from cart where cartId=?`,[cartId],
                              (err, result) => {
                                if (err) {
                                  res.send({
                                    status:"error",
                                    err
                                  })
                                  console.error(err)
                                } else {
                                  console.error("9")
                                 result.forEach(r => {
                                  db.query(
                                    `update products set quantity=quantity-? where (id=?)`,[r.quantity,r.productId]);
                                 });
  
  
                                
                                }
                              }
                            );
                         
                          }
                        }
                      );
  
                    }
                  
                  }
                  )
              
              }
            }
          );
        
        }
        else{
          res.send({
            status: "error",
            msg: "لا يمكن انشاء طلبية لهذه السلة"
          
          });
        }
        }
      }
    );
  }



});
router.get("/getCoupons",userMiddleware.isSuperAdmin, function (req, res) {
  db.query(
    `select * from coupons order by id desc`,
    (err, result) => {
      if (err) {
        console.log(err)
      } else {
        res.send({
          status: "success",
          data: result,
        });
      }
    }
  );

});
router.get("/checkCoupon", function (req, res) {
  db.query(
    `select * from coupons where (code =? and exp_date>CURRENT_TIMESTAMP and validity>0)`,[req.query.code],
    (err, result) => {
      if (err) {
        console.log(err)
        res.send({
          status:"error",
          msg:err
        })
      } else {
        res.send({
          status: "success",
          data: result,
        });
      }
    }
  );

});
router.get("/getCustomer", userMiddleware.isSuperAdmin, function (req, res) {
  const query = `
    SELECT 
      customers.id,
      customers.name,
      customers.mobile,
      cities.name as city,
      customers.address,
      customers.source,
      customers.pricetype,
      COALESCE(SUM(order_totals.totalAmount), 0) as totalOrderAmount,
      COALESCE(SUM(payment_totals.totalPaidAmount), 0) as totalPaidAmount,
      (COALESCE(SUM(order_totals.totalAmount), 0) - COALESCE(SUM(payment_totals.totalPaidAmount), 0)) as remainingBalance
    FROM customers
    LEFT JOIN cities ON customers.city = cities.id
    LEFT JOIN (
      SELECT 
        orders.userId,
        orders.orderNumber,
        SUM(
          (cart.subtotalAmount + orders.shipping - orders.discount) - 
          CASE 
            WHEN orders.couponType = 'ثابت' THEN orders.couponValue 
            WHEN orders.couponType = 'نسبة مئوية' THEN cart.subtotalAmount * (orders.couponValue / 100) 
            ELSE 0 
          END
        ) as totalAmount
      FROM orders
      LEFT JOIN (
        SELECT 
          orderNumber,
          SUM(price * quantity) as subtotalAmount
        FROM cart
        GROUP BY orderNumber
      ) as cart ON orders.orderNumber = cart.orderNumber
      GROUP BY orders.userId, orders.orderNumber
    ) as order_totals ON customers.id = order_totals.userId
    LEFT JOIN (
      SELECT 
        orderId,
        SUM(amount) as totalPaidAmount
      FROM orderspayments
      GROUP BY orderId
    ) as payment_totals ON order_totals.orderNumber = payment_totals.orderId
    WHERE customers.id = ?
    GROUP BY customers.id, customers.name, customers.mobile, cities.name, customers.address, customers.source, customers.pricetype;
  `;

  db.query(query, [req.query.id], (err, result) => {
    if (err) {
      console.log(err);
      res.send({
        status: "error",
        message: "An error occurred while fetching customer details.",
      });
    } else {
      res.send({
        status: "success",
        data: result,
      });
    }
  });
});

router.post("/addCoupon",userMiddleware.isSuperAdmin, function (req, res) {
  const {
    code,coupontype,couponvalue,exp_date,validity
  }=req.body
  db.query(
    `insert into coupons (code,coupontype,couponvalue,exp_date,validity) values( ? ,? ,? ,? ,?)`,[code,coupontype,couponvalue,exp_date,validity],
    (err, result) => {
      if (err) {
        console.log(err)
        res.send({
          status:"error",
          msg:err
        })
      } else {
        res.send({
          status: "success",
          msg: "Coupon Added",
        });
      }
    }
  );

});

router.post("/addBanner",userMiddleware.isSuperAdmin, function (req, res) {
  const {
    url,position
  }=req.body
  db.query(
    `insert into banners (url,position) values( ? ,?)`,[url,position],
    (err, result) => {
      if (err) {
        console.log(err)
        res.send({
          status:"error",
          msg:err
        })
      } else {
        res.send({
          status: "success",
          msg: "Banner Added",
        });
      }
    }
  );

});

router.get("/getBanners", function (req, res) {

  db.query(
    `select * from banners order by id desc`,
    (err, result) => {
      if (err) {
        console.log(err)
        res.send({
          status:"error",
          msg:err
        })
      } else {
        res.send({
          status: "success",
          data: result,
        });
      }
    }
  );

});

router.get("/deleteBanner",userMiddleware.isSuperAdmin, function (req, res) {

  const {id}=req.query
  db.query(
    `delete from banners where id=?`,[id],
    (err, result) => {
      if (err) {
        console.log(err)
        res.send({
          status:"error",
          msg:err
        })
      } else {
        res.send({
          status: "success",
          msg: "Banner Deleted",
        });
      }
    }
  );

});

router.post("/editCoupon",userMiddleware.isSuperAdmin, function (req, res) {
  const {
    code,coupontype,couponvalue,exp_date,validity,id
  }=req.body
  db.query(
    `update coupons set code=?, coupontype=?,couponvalue=?,exp_date=?,validity=? where id=?`,[code,coupontype,couponvalue,exp_date,validity,id],
    (err, result) => {
      if (err) {
        console.log(err)
        res.send({
          status:"error",
          msg:err
        })
      } else {
        res.send({
          status: "success",
          msg: "Coupon Edited",
        });
      }
    }
  );

});
router.post("/editOrder",userMiddleware.isSuperAdmin, function (req, res) {
  const {
    city,address,mobile,discount,shipping,customerName,source,id
  }=req.body
  db.query(
    `update orders set city=?, address=?,mobile=?,discount=?,shipping=?,customerName=?,source=? where id=?`,[city,address,mobile,discount,shipping,customerName,source,id],
    (err, result) => {
      if (err) {
        console.log(err)
        res.send({
          status:"error",
          msg:err
        })
      } else {
        res.send({
          status: "success",
          msg: "Order Edited",
        });
      }
    }
  );

});
router.post("/editCart",userMiddleware.isSuperAdmin, function (req, res) {
  const {
    id,price,quantity
  }=req.body
  db.query(
    `update cart set price=?, quantity=? where id=?`,[price,quantity,id],
    (err, result) => {
      if (err) {
        console.log(err)
        res.send({
          status:"error",
          msg:err
        })
      } else {
        res.send({
          status: "success",
          msg: "Cart Edited",
        });
      }
    }
  );

});

router.get("/deleteCoupon",userMiddleware.isSuperAdmin, function (req, res) {
  const {
   id
  }=req.query
  db.query(
    `delete from coupons where id=?`,[id],
    (err, result) => {
      if (err) {
        console.log(err)
        res.send({
          status:"error",
          msg:err
        })
      } else {
        res.send({
          status: "success",
          msg: "Coupon Deleted",
        });
      }
    }
  );

});
router.get("/returnCart",userMiddleware.isSuperAdmin, function (req, res) {
  const {
   id
  }=req.query
  db.query(
    `select * from cart where id=?`,[id],
    (err, cart) => {
      if (err) {
        console.log(err)
        res.send({
          status:"error",
          msg:err
        })
      } else {
       if(cart.length){
        db.query(`update cart set quantity=0 where id=?`,[id]);
        db.query(`update products set quantity=quantity+? where (itemno=? and name=? and unit=?)`,[cart[0].quantity,cart[0].productItemNumber,cart[0].name,cart[0].unit]);

        res.send({
          status:"success",
          msg:"Product returned successfully"
        })
       }
      }
    }
  );

});
router.get("/getCustomers", userMiddleware.isSuperAdmin, function (req, res) {
  const query = `
    SELECT 
      customers.id,
      customers.name,
      customers.mobile,
      cities.name as city,
      customers.address,
      customers.source,
      customers.pricetype,
      COALESCE(SUM(order_totals.totalAmount), 0) as totalOrderAmount,
      COALESCE(SUM(payment_totals.totalPaidAmount), 0) as totalPaidAmount,
      (COALESCE(SUM(order_totals.totalAmount), 0) - COALESCE(SUM(payment_totals.totalPaidAmount), 0)) as remainingBalance
    FROM customers
    LEFT JOIN cities ON customers.city = cities.id
    LEFT JOIN (
      SELECT 
        orders.userId,
        orders.orderNumber,
        SUM(
          (cart.subtotalAmount + orders.shipping - orders.discount) - 
          CASE 
            WHEN orders.couponType = 'ثابت' THEN orders.couponValue 
            WHEN orders.couponType = 'نسبة مئوية' THEN cart.subtotalAmount * (orders.couponValue / 100) 
            ELSE 0 
          END
        ) as totalAmount
      FROM orders
      LEFT JOIN (
        SELECT 
          orderNumber,
          SUM(price * quantity) as subtotalAmount
        FROM cart
        GROUP BY orderNumber
      ) as cart ON orders.orderNumber = cart.orderNumber
      GROUP BY orders.userId, orders.orderNumber
    ) as order_totals ON customers.id = order_totals.userId
    LEFT JOIN (
      SELECT 
        orderId,
        SUM(amount) as totalPaidAmount
      FROM orderspayments
      GROUP BY orderId
    ) as payment_totals ON order_totals.orderNumber = payment_totals.orderId
    GROUP BY customers.id, customers.name, customers.mobile, cities.name, customers.address, customers.source, customers.pricetype
    ORDER BY customers.id DESC;
  `;

  db.query(query, (err, result) => {
    if (err) {
      console.log(err);
      res.send({
        status: "error",
        message: "An error occurred while fetching customers.",
      });
    } else {
      res.send({
        status: "success",
        data: result,
      });
    }
  });
});


router.get("/getCities", function (req, res) {


  const https = require('https');

// URL you want to send the GET request to
const url = 'https://www.directexpress.ps/?app=package.api&do=list_cites&user_id=2690&key=3002c827a7771852dbdb2129a7328dc6';

// Make the GET request
https.get(url, (response) => {
  let data = '';

  // A chunk of data has been received
  response.on('data', (chunk) => {
    data += chunk;
  });

  // The whole response has been received
  response.on('end', () => {

    try{
      console.error(data); // Output the received data

      const values = JSON.parse(data).map(item => [item, 0]);
  
        db.query(
          `insert into cities (name,price) values ? ON DUPLICATE KEY UPDATE name=name`,[values],
          (err, result) => {
            if (err) {
              console.log(err)
             
            }  {
              db.query(
                `select * from cities order by name asc`,
                (err, result) => {
                  if (err) {
                    console.log(err)
                    res.send(err)
  
                  } else {
                    res.send({
                      status: "success",
                      data: result,
                    });
                  }
                }
              );
            }
          }
        );
    
  
    }
    catch{
      db.query(
        `select * from cities order by name asc`,
        (err, result) => {
          if (err) {
            console.log(err)
          } else {
            res.send({
              status: "success",
              data: result,
            });
          }
        }
      );
    }
  
  });
}).on('error', (error) => {

  db.query(
    `select * from cities order by name asc`,
    (err, result) => {
      if (err) {
        console.log(err)
      } else {
        res.send({
          status: "success",
          data: result,
        });
      }
    }
  );

});




});
  router.post("/newPassword",userMiddleware.isSuperAdmin, function (req, res) {

    const {password}=req.body

    
  bcrypt.hash(password, 10, (err, hash) => {
    if (err) {
      return res.status(500).send({
        msg: err,
      });
    } else {
     
        db.query(
            `update admins set password=? where id =?`,[hash,req.userData.userId],
            (err, result) => {
              if (err) {
                console.log(err)
              } else {
                res.send({
                  status: "success",
                  msg: "تم تغيير كلمة المرور بنجاح",
                });
              }
            }
          );
        


    }
  });
   
  
});
router.post("/addProduct",userMiddleware.isSuperAdmin, function (req, res) {
  const {image,name,quantity,unit,cost,price1,price2,price3,itemno,barcode,categoryName,description,deletedprice}=req.body
  db.query(
    `insert into categories (name) values(?)`,[categoryName],
    (err, result) => {
      if (err) {
        console.error(err)
        db.query(
          `select * from categories where name=?`,[categoryName],
          (err, result) => {
            if (err) {
              console.error(err)
                        } else {
              db.query(
                `insert into products (image,name,quantity,unit,cost,price1,price2,price3,itemno,barcode,category,description,deletedprice) values(?,?,?,?,?,?,?,?,?,?,?,?,?)`,[image,name,quantity,unit,cost,price1,price2,price3,itemno,barcode,result[0].id,description,deletedprice],
                (err, result) => {
                  if (err) {
                    console.error(err)
                  } else {
                    res.send({
                      status: "success",
                      msg: "product added",
                    });
                  }
                }
              );
            }
          }
        );
            } else {
        db.query(
          `select * from categories where name=?`,[categoryName],
          (err, result) => {
            if (err) {
              console.error(err)
            } else {
              db.query(
                `insert into products (image,name,quantity,unit,cost,price1,price2,price3,itemno,barcode,category,description,deletedprice) values(?,?,?,?,?,?,?,?,?,?,?,?,?)`,[image,name,quantity,unit,cost,price1,price2,price3,itemno,barcode,result[0].id,description,deletedprice],
                (err, result) => {
                  if (err) {
                    console.error(err)
                  } else {
                    res.send({
                      status: "success",
                      msg: "product added",
                    });
                  }
                }
              );
            }
          }
        );
      }
    }
  );


});
router.post("/editProduct",userMiddleware.isSuperAdmin, function (req, res) {
  const {image,name,quantity,unit,cost,price1,price2,price3,barcode,itemno,id,categoryName,description,deletedprice}=req.body



  db.query(
    `insert into categories (name) values(?)`,[categoryName],
    (err, result) => {
      if (err) {
        db.query(
          `select * from categories where name=?`,[categoryName],
          (err, result) => {
            if (err) {
              console.log(err)
            } else {
              db.query(
                `update products set image=?,name=?,itemno=?,quantity=?,unit=?,cost=?,price1=?,price2=?,price3=?,barcode=?,category=?,description=?,deletedprice=? where id=? `,[image,name,itemno,quantity,unit,cost,price1,price2,price3,barcode,result[0]?.id||null,description,deletedprice,id],
                (err, result) => {
                  if (err) {
                    console.log(err)
                  } else {
                    res.send({
                      status: "success",
                      msg: "product Edited",
                    });
                  }
                }
              );
            }
          }
        );
            } else {
        db.query(
          `select * from categories where name=?`,[categoryName],
          (err, result) => {
            if (err) {
              console.log(err)
            } else {
              db.query(
                `update products set image=?,name=?,itemno=?,quantity=?,unit=?,cost=?,price1=?,price2=?,price3=?,barcode=?,category=?,description=?,deletedprice=? where id=? `,[image,name,itemno,quantity,unit,cost,price1,price2,price3,barcode,result[0]?.id||null,description,deletedprice,id],
                (err, result) => {
                  if (err) {
                    console.log(err)
                  } else {
                    res.send({
                      status: "success",
                      msg: "product Edited",
                    });
                  }
                }
              );
            }
          }
        );
      }
    }
  );








});
router.post("/editCustomer",userMiddleware.isSuperAdmin, function (req, res) {
  const {name,mobile,city,address,source,pricetype,id}=req.body



  db.query(
    `select * from cities where name=?`,[city],
    (err, result) => {
      if (err) {
        console.log(err)
      } else {
        db.query(
          `update customers set name=?,mobile=?,city=?,address=?,source=?,pricetype=? where id=? `,[name,mobile,result[0]?.id||null,address,source,pricetype,id],
          (err, result) => {
            if (err) {
              console.log(err)
            } else {
              res.send({
                status: "success",
                msg: "Customer Edited",
              });
            }
          }
        );
      }
    }
  );







});
router.post("/editCity",userMiddleware.isSuperAdmin, function (req, res) {
  const {price,id}=req.body



  db.query(
    `update cities set price=? where id=? `,[price,id],
    (err, result) => {
      if (err) {
        console.log(err)
      } else {
        res.send({
          status: "success",
          msg: "City Edited",
        });
      }
    }
  );






});
router.post("/addCustomer",userMiddleware.isSuperAdmin, function (req, res) {
  const {name,mobile,city,address,source,pricetype}=req.body



  db.query(
    `select * from cities where name=?`,[city],
    (err, result) => {
      if (err) {
        console.log(err)
        res.send({
          status:"err",
          msg:err
        })
      } else {
        db.query(
          `insert into customers (name,mobile,city,address,source,pricetype) values(?,?,?,?,?,?)`,[name,mobile,result[0]?.id||null,address,source,pricetype],
          (err, result) => {
            if (err) {
              console.log(err)
              console.log(err)
              res.send({
                status:"err",
                msg:err
              })
            } else {
              res.send({
                status: "success",
                msg: "Customer Added",
              });
            }
          }
        );
      }
    }
  );







});
router.get("/getCategories", function (req, res) {
  db.query(
    `select * from categories order by name asc`,
    (err, result) => {
      if (err) {
        console.log(err)
      } else {
        res.send({
          status: "success",
          data: result,
        });
      }
    }
  );

});
router.get("/deleteProduct",userMiddleware.isSuperAdmin, function (req, res) {
  const {id}=req.query
  db.query(
    `delete from products where id=?`,[id],
    (err, result) => {
      if (err) {
        console.log(err)
      } else {
        res.send({
          status: "success",
          msg: "product deleted",
        });
      }
    }
  );

});

router.post("/changePasswordCustomer",userMiddleware.isLoggedIn, (req, res, next) => {
  const { oldPassword, newPassword } = req.body;
  db.query(
    `SELECT * FROM customers WHERE (id=?);`,
    [req.userData.userId],
    (err, result) => {
      if (err) {
        return res.status(400).send({
          msg: err,
        });
      }
      if (!result.length) {
        return res.status(401).send({
          status: "err",
          msg: "المعلومات المدخلة غير صحيحة",
        });
      }

      bcrypt.compare(oldPassword, result[0]["password"], (bErr, bResult) => {
        if (bErr) {
          return res.status(401).send({
            status: "err",

            msg: "المعلومات المدخلة غير صحيحة",
          });
        }

        if (bResult) {
          {
              bcrypt.hash(newPassword, 10, (err, hash) => {
                  if (err) {
                    return res.status(500).send({
                      msg: err,
                    });
                  } else {
                   
                      db.query(
                          `update customers set password=? where id =?`,[hash,req.userData.userId],
                          (err, result) => {
                            if (err) {
                              console.log(err)
                            } else {
                              res.send({
                                status: "success",
                                msg: "تم تغيير كلمة المرور بنجاح",
                              });
                            }
                          }
                        );
                      
              
              
                  }
                });
          }
        }

        else
        return res.status(401).send({
          status: "err",
          msg: "المعلومات المدخلة غير صحيحة",
        });
      });
    }
  );
});
router.post("/customerLogin", (req, res, next) => {
  const { mobile, password } = req.body;
  db.query(
    `SELECT * FROM customers WHERE (mobile=?);`,
    [mobile],
    (err, result) => {
      if (err) {
        return res.status(400).send({
          msg: err,
        });
      }
      if (!result.length) {
        return res.status(401).send({
          status: "err",
          msg: "المعلومات المدخلة غير صحيحة",
        });
      }

      bcrypt.compare(password, result[0]["password"], (bErr, bResult) => {
        if (bErr) {
          return res.status(401).send({
            status: "err",

            msg: "المعلومات المدخلة غير صحيحة",
          });
        }

        if (bResult) {
          {
            const token = jwt.sign(
              {
                userId: result[0].id,
                role:"customer"
              },
              process.env.JWT_KEY,
              {
                expiresIn: "60d",
              }
            );

            db.query(
              `UPDATE customers SET lastlogin = now() WHERE id = '${result[0].id}'`
            );
       

            return res.status(200).send({
              status: "success",
              msg: "Logged In!",
              token,
            });
          }
        }

        return res.status(401).send({
          status: "err",
          msg: "المعلومات المدخلة غير صحيحة",
        });
      });
    }
  );
});
router.post("/adminlogin", (req, res, next) => {
    const { email,username, password } = req.body;
    console.log(email,password)
    db.query(
      `SELECT * FROM admins WHERE (email=? or email =?);`,
      [email,username],
      (err, result) => {
        if (err) {
          return res.status(400).send({
            msg: err,
          });
        }
        if (!result.length) {
          return res.status(401).send({
            status: "err",
            msg: "المعلومات المدخلة غير صحيحة",
          });
        }
  
        bcrypt.compare(password, result[0]["password"], (bErr, bResult) => {
          if (bErr) {
            return res.status(401).send({
              status: "err",
  
              msg: "المعلومات المدخلة غير صحيحة",
            });
          }
  
          if (bResult) {
            {
              const token = jwt.sign(
                {
                  userId: result[0].id,
                  role:"admin"
                },
                process.env.JWT_KEY,
                {
                  expiresIn: "60d",
                }
              );
  
              db.query(
                `UPDATE admins SET lastlogin = now() WHERE id = '${result[0].id}'`
              );
         
  
              return res.status(200).send({
                status: "success",
                msg: "Logged In!",
                token,
              });
            }
          }
  
          return res.status(401).send({
            status: "err",
            msg: "المعلومات المدخلة غير صحيحة",
          });
        });
      }
    );
});
  router.post("/changePassword",userMiddleware.isSuperAdmin, (req, res, next) => {
    const { oldPassword, newPassword } = req.body;
    db.query(
      `SELECT * FROM admins WHERE (id=?);`,
      [req.userData.userId],
      (err, result) => {
        if (err) {
          return res.status(400).send({
            msg: err,
          });
        }
        if (!result.length) {
          return res.status(401).send({
            status: "err",
            msg: "المعلومات المدخلة غير صحيحة",
          });
        }
  
        bcrypt.compare(oldPassword, result[0]["password"], (bErr, bResult) => {
          if (bErr) {
            return res.status(401).send({
              status: "err",
  
              msg: "المعلومات المدخلة غير صحيحة",
            });
          }
  
          if (bResult) {
            {
                bcrypt.hash(newPassword, 10, (err, hash) => {
                    if (err) {
                      return res.status(500).send({
                        msg: err,
                      });
                    } else {
                     
                        db.query(
                            `update admins set password=? where id =?`,[hash,req.userData.userId],
                            (err, result) => {
                              if (err) {
                                console.log(err)
                              } else {
                                res.send({
                                  status: "success",
                                  msg: "تم تغيير كلمة المرور بنجاح",
                                });
                              }
                            }
                          );
                        
                
                
                    }
                  });
            }
          }
  
          else
          return res.status(401).send({
            status: "err",
            msg: "المعلومات المدخلة غير صحيحة",
          });
        });
      }
    );
});
  router.post("/resetPassword", (req, res, next) => {
    const { email } = req.body;
    console.log(email)
    db.query(
      `SELECT * FROM admins WHERE (email=?);`,
      [email],
      (err, result) => {
        if (err) {
          return res.status(400).send({
            msg: err,
          });
        }
        if (!result.length) {
          return res.status(401).send({
            status: "err",
            msg: "المعلومات المدخلة غير صحيحة",
          });
        }
  
        {
            const token = jwt.sign(
              {
                userId: result[0].id,
                role:"admin"
              },
              process.env.JWT_KEY,
              {
                expiresIn: "60d",
              }
            );

            db.query(
              `UPDATE admins SET lastlogin = now() WHERE id = '${result[0].id}'`
            );
       

            return res.status(200).send({
              status: "success",
              msg: "Logged In!",
              link:"resetPassword?token="+token,
            });
          }
      }
    );
});
router.post("/login", (req, res, next) => {
  const { username, password } = req.body;
  db.query(
    `SELECT * FROM users WHERE (username=?);`,
    [username],
    (err, result) => {
      if (err) {
        console.log(err)
        return res.status(400).send({
          msg: err,
        });
      }
      if (!result.length) {
        return res.status(401).send({
          status: "err",
          msg: "المعلومات المدخلة غير صحيحة",
        });
      }

      bcrypt.compare(password, result[0]["password"], (bErr, bResult) => {
        if (bErr) {
          return res.status(401).send({
            status: "err",

            msg: "المعلومات المدخلة غير صحيحة",
          });
        }

        if (bResult) {
          {
            const token = jwt.sign(
              {
                userId: result[0].id,
                role:"user"
              },
              process.env.JWT_KEY,
              {
                expiresIn: "60d",
              }
            );
            db.query(
              `UPDATE users SET lastlogin = now() WHERE id = '${result[0].id}'`
            );

            return res.status(200).send({
              status: "success",
              msg: "Logged In!",
              token,
            });
          }
        }

        return res.status(401).send({
          status: "err",
          msg: "المعلومات المدخلة غير صحيحة",
        });
      });
    }
  );
});
router.get("/userData",userMiddleware.isLoggedIn, function (req, res) {
  db.query(
    `select * from users where id =?`,[req.userData.userId],
    (err, result) => {
      if (err) {
      } else {
        res.send({
          status: "success",
          data: result[0],
        });
      }
    }
  );

});
router.get("/addToWishList",userMiddleware.isLoggedIn, function (req, res) {
  db.query(
    `insert into wishlist (user,product) values (?,?)`,[req.userData.userId,req.query.productId],
    (err, result) => {
      if (err) {
        db.query(
          `delete from wishlist where (user=? and product=?)`,[req.userData.userId,req.query.productId],
          (err, result) => {
            if (err) {
              
            } else {
              res.send({
                status: "success",
                msg:"تم حذف المنتج من المفضلة بنجاح",
              });
            }
          }
        );
      } else {
        res.send({
          status: "success",
          msg:"تم اضافة المنتج الى المفضلة بنجاح",
        });
      }
    }
  );

});
router.get("/getWishList",userMiddleware.isLoggedIn, function (req, res) {
  db.query(
    `  SELECT 
      
      products.id, 
      products.itemno,
      products.image,
      products.name,
      products.quantity,
      products.unit,
      products.price1 as price,
      products.barcode,
      products.description,
      products.views,
      products.deletedprice,
      categories.id as categoryId,
      categories.name as categoryName 
    FROM 
      wishlist
      LEFT JOIN products on wishlist.product=products.id 
    LEFT JOIN 
      categories 
    ON 
      products.category = categories.id 
    WHERE 
      wishlist.user = ?`,[req.userData.userId],
    (err, result) => {
      if (err) {
        res.send({
          status: "error",
          msg:err,
        });
      } else {
        res.send({
          status: "success",
          result:result,
        });
      }
    }
  );

});
router.get("/notifications",userMiddleware.isLoggedIn, function (req, res) {
  db.query(
    `select * from notifications where user =? order by id desc`,[req.userData.userId],
    (err, result) => {
      if (err) {
        console.log(err)
      } else {
        res.send({
          status: "success",
          data: result,
        });
      }
    }
  );

});
router.get("/registerPushToken",userMiddleware.isLoggedIn, function (req, res) {
  const {token}=req.query
  db.query(
    `insert into notificationtokens (user,token) values(?,?)`,[req.userData.userId,token],
    (err, result) => {
      if (err) {
        console.log(err)
      } else {
        res.send({
          status: "success",
          data: result,
        });
        
      }
    }
  );
});
router.get("/logout",userMiddleware.isLoggedIn, function (req, res) {
  const {token}=req.query
  console.log(token)
  db.query(
    `delete from notificationtokens where (token=? and user=?)`,[token,req.userData.userId],
    (err, result) => {
      if (err) {
        console.log(err)
      } else {
        res.send({
          status: "success",
          data: result,
        });    
      }
    }
  );
});
router.post("/upload", function (req, res) {
  console.log(req.file)

  upload(req, res, function (err) {
    if (err instanceof multer.MulterError) {
      // A Multer error occurred when uploading.
      console.log(err)

      res.status(500).json(err);
    } else if (err) {
      // An unknown error occurred when uploading.
      console.log(err)
      res.status(500).json(err);
    } else {
      // Everything went fine.

      const fileUrl =
        req.protocol + "://" + req.get("host") + "/api/" + req.file.path.replace("\\","/");
        console.log(fileUrl)
      res.status(200).json({ url: fileUrl,name:req.file.originalname });
    }
  });
});
const mime = require('mime-types');
const sharp = require('sharp');

router.get('/uploads/:file', async (req, res) => {
  const imagePath = `./uploads/${req.params.file}`; // replace with your own image path

  try {
    const mimeType = mime.lookup(imagePath);

    // Read the file from the file system
    const file = fs.readFileSync(imagePath);

    // Check if the file is an image
    if (mimeType.startsWith('image/')) {
      // Set the target file size in bytes (500 KB)
      const targetSize = 500 * 1024;

      let resizedImageBuffer = file;
      let quality = 80; // Start with a quality of 80%
      let width = 800; // Start with a width of 800px

      // Iterate resizing until the desired file size is achieved
      while (resizedImageBuffer.length > targetSize && quality > 10) {
        resizedImageBuffer = await sharp(file)
          .resize({ width })
          .jpeg({ quality })
          .toBuffer();

        quality -= 10;
        width -= 100; // Reduce the width by 100px each iteration
      }

      const contentType = mimeType;
      const contentLength = Buffer.byteLength(resizedImageBuffer);

      res.writeHead(200, {
        'Content-Type': contentType,
        'Content-Length': contentLength,
      });
      res.end(resizedImageBuffer);
    } else {
      // If the file is not an image, return it as it is
      const contentType = mimeType;
      const contentLength = Buffer.byteLength(file);

      res.writeHead(200, {
        'Content-Type': contentType,
        'Content-Length': contentLength,
      });
      res.end(file);
    }
  } catch (err) {
    console.error(err);
    res.status(500).send(err);
  }
});


router.post("/sendNotification", userMiddleware.isSuperAdmin, (req, res, next) => {

  const {title,body,users}=req.body
  db.query(
    `select token from notificationtokens where user in (?)`,[users],
    (err, result) => {
      if (err) {
        console.log(err)
    
      } else {
let expo = new Expo({ accessToken: process.env.EXPO_ACCESS_TOKEN });

let messages = [];
for (let pushToken of result) {
console.log(pushToken)
  pushToken=pushToken.token
  if (!Expo.isExpoPushToken(pushToken)) {
    console.error(`Push token ${pushToken} is not a valid Expo push token`);
    continue;
  }

  messages.push({
    to: pushToken,
    sound: 'default',
    title,
    body
  })
}
res.send({
  status: "success",
  data: result,
});

users.forEach(user => {
  try{
    db.query(`insert into notifications (user,title,body) values(?,?,?)`,[user,title,body],
    (err, result) => {
      if (err) {
        console.log(err)
    
      }
    
    }
      )

  } catch{
      
    }

});
let chunks = expo.chunkPushNotifications(messages);
let tickets = [];
(async () => {
  for (let chunk of chunks) {
    try {
      let ticketChunk = await expo.sendPushNotificationsAsync(chunk);
      console.log(ticketChunk);
      tickets.push(...ticketChunk);
    } catch (error) {
      console.error(error);
    }
  }
})();


let receiptIds = [];
for (let ticket of tickets) {
  if (ticket.id) {
    receiptIds.push(ticket.id);
  }
}

let receiptIdChunks = expo.chunkPushNotificationReceiptIds(receiptIds);
(async () => {
  for (let chunk of receiptIdChunks) {
    try {
      let receipts = await expo.getPushNotificationReceiptsAsync(chunk);
      console.log(receipts);
      for (let receiptId in receipts) {
        let { status, message, details } = receipts[receiptId];
        if (status === 'ok') {
          continue;
        } else if (status === 'error') {
          console.error(
            `There was an error sending a notification: ${message}`
          );
          if (details && details.error) {
            console.error(`The error code is ${details.error}`);
          }
        }
      }
    } catch (error) {
      console.error(error);
    }
  }
})();
      }
    }
  );
});

const sendNotification=(title,body,users)=>{
  

  db.query(
    `select token from notificationtokens where user in (?)`,[users],
    (err, result) => {
      if (err) {
        console.log(err)
    
      } else {
let expo = new Expo({ accessToken: process.env.EXPO_ACCESS_TOKEN });

let messages = [];
for (let pushToken of result) {
console.log(pushToken)
  pushToken=pushToken.token
  if (!Expo.isExpoPushToken(pushToken)) {
    console.error(`Push token ${pushToken} is not a valid Expo push token`);
    continue;
  }

  messages.push({
    to: pushToken,
    sound: 'default',
    title,
    body
  })
}
users.forEach(user => {
  try{
    db.query(`insert into notifications (user,title,body) values(?,?,?)`,[user,title,body],
    (err, result) => {
      if (err) {
        console.log(err)
    
      }
    
    }
      )

  } catch{
      
    }

});
let chunks = expo.chunkPushNotifications(messages);
let tickets = [];
(async () => {
  for (let chunk of chunks) {
    try {
      let ticketChunk = await expo.sendPushNotificationsAsync(chunk);
      console.log(ticketChunk);
      tickets.push(...ticketChunk);
    } catch (error) {
      console.error(error);
    }
  }
})();


let receiptIds = [];
for (let ticket of tickets) {
  if (ticket.id) {
    receiptIds.push(ticket.id);
  }
}

let receiptIdChunks = expo.chunkPushNotificationReceiptIds(receiptIds);
(async () => {
  for (let chunk of receiptIdChunks) {
    try {
      let receipts = await expo.getPushNotificationReceiptsAsync(chunk);
      console.log(receipts);
      for (let receiptId in receipts) {
        let { status, message, details } = receipts[receiptId];
        if (status === 'ok') {
          continue;
        } else if (status === 'error') {
          console.error(
            `There was an error sending a notification: ${message}`
          );
          if (details && details.error) {
            console.error(`The error code is ${details.error}`);
          }
        }
      }
    } catch (error) {
      console.error(error);
    }
  }
})();
      }
    }
  );

}
module.exports = router;
